/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.JSchConnector;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSchSSHPasswordAuthenticator
extends SSHAuthenticator<JSchConnector, StandardUsernamePasswordCredentials> {
    private static final Logger LOGGER = Logger.getLogger(JSchSSHPasswordAuthenticator.class.getName());

    protected JSchSSHPasswordAuthenticator(@NonNull JSchConnector connection, @NonNull StandardUsernamePasswordCredentials user) {
        super(connection, user);
    }

    @Override
    @NonNull
    public SSHAuthenticator.Mode getAuthenticationMode() {
        return SSHAuthenticator.Mode.BEFORE_CONNECT;
    }

    @Override
    public boolean canAuthenticate() {
        return !((JSchConnector)this.getConnection()).hasSession() || ((JSchConnector)this.getConnection()).getSession().isConnected() && ((JSchConnector)this.getConnection()).getSession().getUserInfo() == null;
    }

    @Override
    protected boolean doAuthenticate() {
        Session session = ((JSchConnector)this.getConnection()).getSession();
        session.setUserInfo((UserInfo)new JSchUserInfo());
        session.setPassword(((StandardUsernamePasswordCredentials)this.getUser()).getPassword().getPlainText());
        return true;
    }

    private class JSchUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private JSchUserInfo() {
        }

        public String getPassphrase() {
            return "";
        }

        public String getPassword() {
            return ((StandardUsernamePasswordCredentials)JSchSSHPasswordAuthenticator.this.getUser()).getPassword().getPlainText();
        }

        public boolean promptPassword(String message) {
            LOGGER.info(message);
            return true;
        }

        public boolean promptPassphrase(String message) {
            LOGGER.info(message);
            return false;
        }

        public boolean promptYesNo(String message) {
            LOGGER.info(message);
            return false;
        }

        public void showMessage(String message) {
            LOGGER.info(message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] stringArray;
            if (prompt != null && prompt.length > 0 && prompt[0].toLowerCase().contains("assword")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ((StandardUsernamePasswordCredentials)JSchSSHPasswordAuthenticator.this.getUser()).getPassword().getPlainText();
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(optional=true)
    public static class Factory
    extends SSHAuthenticatorFactory {
        private static final long serialVersionUID = 1L;

        @Override
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user) {
            if (this.supports(connection.getClass(), user.getClass())) {
                return new JSchSSHPasswordAuthenticator((JSchConnector)connection, (StandardUsernamePasswordCredentials)user);
            }
            return null;
        }

        @Override
        protected <C, U extends StandardUsernameCredentials> boolean supports(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
            return JSchConnector.class.isAssignableFrom(connectionClass) && StandardUsernamePasswordCredentials.class.isAssignableFrom(userClass);
        }
    }
}

