/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrileadSSHPasswordAuthenticator
extends SSHAuthenticator<Connection, StandardUsernamePasswordCredentials> {
    private static final Logger LOGGER = Logger.getLogger(TrileadSSHPasswordAuthenticator.class.getName());

    public TrileadSSHPasswordAuthenticator(Connection connection, StandardUsernamePasswordCredentials user) {
        super(connection, user);
    }

    @Override
    public boolean canAuthenticate() {
        try {
            for (String authMethod : ((Connection)this.getConnection()).getRemainingAuthMethods(((StandardUsernamePasswordCredentials)this.getUser()).getUsername())) {
                if ("password".equals(authMethod)) {
                    return true;
                }
                if (!"keyboard-interactive".equals(authMethod)) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.getListener().error("Failed to authenticate"));
        }
        return false;
    }

    @Override
    protected boolean doAuthenticate() {
        StandardUsernamePasswordCredentials user = (StandardUsernamePasswordCredentials)this.getUser();
        String username = user.getUsername();
        try {
            Connection connection = (Connection)this.getConnection();
            final String password = user.getPassword().getPlainText();
            boolean tried = false;
            List<String> availableMethods = Arrays.asList(connection.getRemainingAuthMethods(username));
            if (availableMethods.contains("password")) {
                if (connection.authenticateWithPassword(username, password)) {
                    LOGGER.fine("Authentication with 'password' succeeded.");
                    return true;
                }
                this.getListener().error("Failed to authenticate as %s. Wrong password. (credentialId:%s/method:password)", new Object[]{username, user.getId()});
                tried = true;
            }
            if (availableMethods.contains("keyboard-interactive")) {
                if (connection.authenticateWithKeyboardInteractive(username, new InteractiveCallback(){

                    public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
                        String[] stringArray;
                        if (prompt != null && prompt.length > 0 && prompt[0].toLowerCase(Locale.ENGLISH).contains("assword")) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = password;
                        } else {
                            stringArray = new String[]{};
                        }
                        return stringArray;
                    }
                })) {
                    LOGGER.fine("Authentication with  'keyboard-interactive' succeeded.");
                    return true;
                }
                this.getListener().error("Failed to authenticate as %s. Wrong password. (credentialId:%s/method:keyboard-interactive)", new Object[]{username, user.getId()});
                tried = true;
            }
            if (!tried) {
                this.getListener().error("The server does not allow password authentication. Available options are %s", new Object[]{availableMethods});
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.getListener().error("Unexpected error while trying to authenticate as %s with credential=%s", new Object[]{username, user.getId()}));
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class Factory
    extends SSHAuthenticatorFactory {
        private static final long serialVersionUID = 1L;

        @Override
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user) {
            if (this.supports(connection.getClass(), user.getClass())) {
                return new TrileadSSHPasswordAuthenticator((Connection)connection, (StandardUsernamePasswordCredentials)user);
            }
            return null;
        }

        @Override
        protected <C, U extends StandardUsernameCredentials> boolean supports(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
            return Connection.class.isAssignableFrom(connectionClass) && StandardUsernamePasswordCredentials.class.isAssignableFrom(userClass);
        }
    }
}

