/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class CollabNetSVN
extends SubversionRepositoryBrowser {
    private static final long serialVersionUID = 4638328794797996597L;
    public final URL url;

    @DataBoundConstructor
    public CollabNetSVN(URL url) {
        this.url = CollabNetSVN.normalizeToEndWithSlash((URL)url);
    }

    @Override
    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int revision = path.getLogEntry().getRevision();
        QueryBuilder query = new QueryBuilder(null);
        query.add("r1=" + (revision - 1));
        query.add("r2=" + revision);
        return new URL(this.url, CollabNetSVN.trimHeadSlash((String)path.getValue()) + String.valueOf(query));
    }

    @Override
    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        int revision = path.getLogEntry().getRevision();
        QueryBuilder query = new QueryBuilder(null);
        query.add("rev=" + revision);
        query.add("view=log");
        return new URL(this.url, CollabNetSVN.trimHeadSlash((String)path.getValue()) + String.valueOf(query));
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        int revision = changeSet.getRevision();
        QueryBuilder query = new QueryBuilder(null);
        query.add("rev=" + revision);
        query.add("view=rev");
        return new URL(this.url, query.toString());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "CollabNet";
        }
    }
}

