/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.forward;

import hudson.remoting.Callable;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketChannelStream;
import hudson.remoting.VirtualChannel;
import hudson.remoting.forward.CopyThread;
import hudson.remoting.forward.Forwarder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

public class ForwarderFactory {
    private static final Logger LOGGER = Logger.getLogger(ForwarderFactory.class.getName());
    public static final Role ROLE = new Role(ForwarderFactory.class);

    public static Forwarder create(VirtualChannel channel, final String remoteHost, final int remotePort) throws IOException, InterruptedException {
        return channel.call(new Callable<Forwarder, IOException>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Forwarder call() throws IOException {
                return new ForwarderImpl(remoteHost, remotePort);
            }

            @Override
            public void checkRoles(RoleChecker checker) throws SecurityException {
                checker.check((RoleSensitive)this, ROLE);
            }
        });
    }

    public static Forwarder create(String remoteHost, int remotePort) {
        return new ForwarderImpl(remoteHost, remotePort);
    }

    private static class ForwarderImpl
    implements Forwarder,
    SerializableOnlyOverRemoting {
        private final String remoteHost;
        private final int remotePort;
        private static final long serialVersionUID = 8382509901649461466L;

        private ForwarderImpl(String remoteHost, int remotePort) {
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
        }

        @Override
        public OutputStream connect(OutputStream out) throws IOException {
            Socket s = new Socket(this.remoteHost, this.remotePort);
            try (InputStream in = SocketChannelStream.in(s);){
                new CopyThread(String.format("Copier to %s:%d", this.remoteHost, this.remotePort), in, out, () -> {
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Problem closing socket for ForwardingFactory", e);
                    }
                }).start();
            }
            return new RemoteOutputStream(SocketChannelStream.out(s));
        }

        private Object writeReplace() throws ObjectStreamException {
            return this.getChannelForSerialization().export(Forwarder.class, this);
        }
    }
}

