/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.constant_pool_scanner;

import java.util.Arrays;
import java.util.List;
import org.jenkinsci.constant_pool_scanner.ClassConstant;
import org.jenkinsci.constant_pool_scanner.FieldRefConstant;
import org.jenkinsci.constant_pool_scanner.InterfaceMethodRefConstant;
import org.jenkinsci.constant_pool_scanner.MethodRefConstant;
import org.jenkinsci.constant_pool_scanner.NameAndTypeConstant;
import org.jenkinsci.constant_pool_scanner.Utf8Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConstantType {
    UTF8(1, Utf8Constant.class, new ConstantType[0]),
    CLASS(7, ClassConstant.class, UTF8),
    NAME_AND_TYPE(12, NameAndTypeConstant.class, UTF8),
    FIELD_REF(9, FieldRefConstant.class, CLASS, NAME_AND_TYPE, UTF8),
    METHOD_REF(10, MethodRefConstant.class, CLASS, NAME_AND_TYPE, UTF8),
    INTERFACE_METHOD_REF(11, InterfaceMethodRefConstant.class, CLASS, NAME_AND_TYPE, UTF8),
    STRING(8, String.class, UTF8),
    INTEGER(3, Integer.class, new ConstantType[0]),
    FLOAT(4, Float.class, new ConstantType[0]),
    LONG(5, Long.class, new ConstantType[0]),
    DOUBLE(6, Double.class, new ConstantType[0]);

    public final Class valueType;
    final List<ConstantType> implies;
    public final int tag;
    private static final ConstantType[] byTag;

    private ConstantType(int tag, Class valueType, ConstantType ... implies) {
        this.tag = tag;
        this.valueType = valueType;
        this.implies = Arrays.asList(implies);
    }

    public static ConstantType fromTag(int tag) {
        return byTag[tag];
    }

    static {
        byTag = new ConstantType[20];
        ConstantType[] arr$ = ConstantType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ConstantType c;
            ConstantType.byTag[c.tag] = c = arr$[i$];
        }
    }
}

