/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class PropertyFromFileMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter(required=true)
    public String file = null;
    @DataBoundTokenMacro.Parameter(required=true)
    public String property = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("PROPFILE");
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String root = context.getWorkspace().getRemote();
        return (String)context.getWorkspace().act((Callable)new ReadProperty(root, this.file, this.property));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadProperty
    implements Callable<String, IOException> {
        private String root;
        private String filename;
        private String propertyname;

        public ReadProperty(String root, String filename, String property) {
            this.root = root;
            this.filename = filename;
            this.propertyname = property;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String call() throws IOException {
            Properties props = new Properties();
            File file = new File(this.root, this.filename);
            String propertyValue = "";
            if (!file.exists()) return this.filename.concat(" not found");
            FileReader reader = new FileReader(file);
            Reader resource = reader;
            try {
                BufferedReader bReader = new BufferedReader(reader);
                resource = bReader;
                props.load(bReader);
                if (!props.containsKey(this.propertyname)) return propertyValue;
                propertyValue = props.getProperty(this.propertyname);
                return propertyValue;
            }
            catch (IOException e) {
                propertyValue = "Error reading ".concat(this.filename);
                return propertyValue;
            }
            finally {
                resource.close();
            }
        }
    }
}

