/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.cli.CLICommand;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.util.FormValidation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.uaznia.lukanus.hudson.plugins.gitparameter.Consts;
import net.uaznia.lukanus.hudson.plugins.gitparameter.FilePathWrapper;
import net.uaznia.lukanus.hudson.plugins.gitparameter.GitParameterValue;
import net.uaznia.lukanus.hudson.plugins.gitparameter.Messages;
import net.uaznia.lukanus.hudson.plugins.gitparameter.RevisionInfo;
import net.uaznia.lukanus.hudson.plugins.gitparameter.RevisionInfoFactory;
import net.uaznia.lukanus.hudson.plugins.gitparameter.SelectedValue;
import net.uaznia.lukanus.hudson.plugins.gitparameter.SmartNumberStringComparer;
import net.uaznia.lukanus.hudson.plugins.gitparameter.SortMode;
import net.uaznia.lukanus.hudson.plugins.gitparameter.Utils;
import net.uaznia.lukanus.hudson.plugins.gitparameter.jobs.JobWrapper;
import net.uaznia.lukanus.hudson.plugins.gitparameter.jobs.JobWrapperFactory;
import net.uaznia.lukanus.hudson.plugins.gitparameter.model.ItemsErrorModel;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.RepoSCM;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.SCMFactory;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class GitParameterDefinition
extends ParameterDefinition
implements Comparable<GitParameterDefinition> {
    private static final long serialVersionUID = 9157832967140868122L;
    private static final Logger LOGGER = Logger.getLogger(GitParameterDefinition.class.getName());
    private final UUID uuid;
    private String type;
    private String branch;
    private String tagFilter;
    private String branchFilter;
    private SortMode sortMode;
    private String defaultValue;
    private SelectedValue selectedValue;
    private String useRepository;
    private Boolean quickFilterEnabled;
    private String listSize;
    private Boolean requiredParameter;

    @DataBoundConstructor
    public GitParameterDefinition(String name, String type, String defaultValue, String description, String branch, String branchFilter, String tagFilter, SortMode sortMode, SelectedValue selectedValue, String useRepository, Boolean quickFilterEnabled) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.branch = branch;
        this.uuid = UUID.randomUUID();
        this.sortMode = sortMode;
        this.selectedValue = selectedValue;
        this.quickFilterEnabled = quickFilterEnabled;
        this.listSize = "5";
        this.requiredParameter = false;
        this.setUseRepository(useRepository);
        this.setParameterType(type);
        this.setTagFilter(tagFilter);
        this.setBranchFilter(branchFilter);
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] value = request.getParameterValues(this.getName());
        if (value == null || value.length == 0 || StringUtils.isBlank((String)value[0])) {
            if (BooleanUtils.isTrue((Boolean)this.requiredParameter)) {
                throw new Failure("Parameter: " + this.getName() + " is required to have a value please select an option");
            }
            return this.getDefaultParameterValue();
        }
        return new GitParameterValue(this.getName(), value[0]);
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        StringBuilder strValue = new StringBuilder();
        if (value instanceof String) {
            strValue.append(value);
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            for (int i = 0; i < jsonValues.size(); ++i) {
                strValue.append(jsonValues.getString(i));
                if (i >= jsonValues.size() - 1) continue;
                strValue.append(",");
            }
        }
        if (strValue.length() == 0) {
            if (BooleanUtils.isTrue((Boolean)this.requiredParameter) && StringUtils.isBlank((String)this.defaultValue)) {
                throw new Failure("Parameter: " + this.getName() + " is required to have a value please select an option");
            }
            strValue.append(this.defaultValue);
        }
        GitParameterValue gitParameterValue = new GitParameterValue(jO.getString("name"), strValue.toString());
        return gitParameterValue;
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        if (StringUtils.isNotEmpty((String)value)) {
            return new GitParameterValue(this.getName(), value);
        }
        if (BooleanUtils.isTrue((Boolean)this.requiredParameter) && StringUtils.isBlank((String)this.getDefaultValue()) && !this.getSelectedValue().equals((Object)SelectedValue.TOP)) {
            throw new Failure("Parameter: " + this.getName() + " is required to have a value please select an option");
        }
        return this.getDefaultParameterValue();
    }

    public ParameterValue getDefaultParameterValue() {
        String defValue = this.getDefaultValue();
        if (!StringUtils.isBlank((String)defValue)) {
            return new GitParameterValue(this.getName(), defValue);
        }
        switch (this.getSelectedValue()) {
            case TOP: {
                try {
                    ItemsErrorModel valueItems = this.getAllValueItems();
                    if (valueItems.size() > 0) {
                        return new GitParameterValue(this.getName(), valueItems.get((int)0).value);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, this.getCustomJobName() + " " + Messages.GitParameterDefinition_unexpectedError(), e);
                }
                break;
            }
            default: {
                return super.getDefaultParameterValue();
            }
        }
        return super.getDefaultParameterValue();
    }

    @Exported
    public ItemsErrorModel getAllValueItems() {
        return this.getDescriptor().doFillValueItems(Utils.getParentJob(this), this.getName());
    }

    public String getParameterType() {
        return this.type;
    }

    public void setParameterType(String type) {
        this.type = Consts.isParameterTypeCorrect(type) ? type : "PT_BRANCH";
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String nameOfBranch) {
        this.branch = nameOfBranch;
    }

    public SortMode getSortMode() {
        return this.sortMode == null ? SortMode.NONE : this.sortMode;
    }

    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
    }

    public String getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(String tagFilter) {
        if (StringUtils.isEmpty((String)StringUtils.trim((String)tagFilter))) {
            tagFilter = "*";
        }
        this.tagFilter = tagFilter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getBranchFilter() {
        return this.branchFilter;
    }

    public void setBranchFilter(String branchFilter) {
        if (StringUtils.isEmpty((String)StringUtils.trim((String)branchFilter))) {
            branchFilter = ".*";
        }
        this.branchFilter = branchFilter;
    }

    public String getListSize() {
        return this.listSize == null ? "5" : this.listSize;
    }

    @DataBoundSetter
    public void setListSize(String listSize) {
        this.listSize = listSize;
    }

    public Boolean getRequiredParameter() {
        return this.requiredParameter;
    }

    @DataBoundSetter
    public void setRequiredParameter(Boolean requiredParameter) {
        this.requiredParameter = requiredParameter;
    }

    public SelectedValue getSelectedValue() {
        return this.selectedValue == null ? SelectedValue.TOP : this.selectedValue;
    }

    public Boolean getQuickFilterEnabled() {
        return this.quickFilterEnabled;
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(GitParameterDefinition pd) {
        return pd.uuid.equals(this.uuid) ? 0 : -1;
    }

    /*
     * Exception decompiling
     */
    public ItemsErrorModel generateContents(JobWrapper jobWrapper, List<GitSCM> scms) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[MONITOR]], but top level block is 8[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ItemsErrorModel convertMapToListBox(Map<String, String> paramList) {
        ItemsErrorModel items = new ItemsErrorModel();
        for (Map.Entry<String, String> entry : paramList.entrySet()) {
            items.add(entry.getValue(), entry.getKey());
        }
        return items;
    }

    private boolean notMatchUseRepository(String gitUrl) {
        Pattern repositoryNamePattern;
        if (StringUtils.isBlank((String)this.useRepository)) {
            return false;
        }
        try {
            repositoryNamePattern = Pattern.compile(this.useRepository);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, Messages.GitParameterDefinition_invalidUseRepositoryPattern(this.useRepository), e.getMessage());
            return false;
        }
        return !repositoryNamePattern.matcher(gitUrl).find();
    }

    private Set<String> getTag(GitClient gitClient, String gitUrl) throws InterruptedException {
        HashSet<String> tagSet = new HashSet<String>();
        try {
            Map tags = gitClient.getRemoteReferences(gitUrl, this.tagFilter, false, true);
            for (String tagName : tags.keySet()) {
                tagSet.add(tagName.replaceFirst(".*refs/tags/", ""));
            }
        }
        catch (GitException e) {
            LOGGER.log(Level.WARNING, this.getCustomJobName() + " " + Messages.GitParameterDefinition_getTag(), e);
        }
        return tagSet;
    }

    private Set<String> getBranch(GitClient gitClient, String gitUrl, String remoteName) throws Exception {
        HashSet<String> branchSet = new HashSet<String>();
        Pattern branchFilterPattern = this.compileBranchFilterPattern();
        Map branches = gitClient.getRemoteReferences(gitUrl, null, true, false);
        Iterator remoteBranchesName = branches.keySet().iterator();
        while (remoteBranchesName.hasNext()) {
            String branchName = this.strip((String)remoteBranchesName.next(), remoteName);
            Matcher matcher = branchFilterPattern.matcher(branchName);
            if (!matcher.matches()) continue;
            if (matcher.groupCount() == 1) {
                branchSet.add(matcher.group(1));
                continue;
            }
            branchSet.add(branchName);
        }
        return branchSet;
    }

    private Set<String> getPullRequest(GitClient gitClient, String gitUrl) throws Exception {
        HashSet<String> pullRequestSet = new HashSet<String>();
        Map remoteReferences = gitClient.getRemoteReferences(gitUrl, null, false, false);
        for (String remoteReference : remoteReferences.keySet()) {
            Matcher matcher = Consts.PULL_REQUEST_REFS_PATTERN.matcher(remoteReference);
            if (!matcher.find()) continue;
            pullRequestSet.add(matcher.group(1));
        }
        return pullRequestSet;
    }

    private Pattern compileBranchFilterPattern() {
        Pattern branchFilterPattern;
        try {
            branchFilterPattern = Pattern.compile(this.branchFilter);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, this.getCustomJobName() + " " + Messages.GitParameterDefinition_branchFilterNotValid(), e.getMessage());
            branchFilterPattern = Pattern.compile(".*");
        }
        return branchFilterPattern;
    }

    private String strip(String name, String remote) {
        return remote + "/" + name.substring(name.indexOf(47, 5) + 1);
    }

    private void getRevision(JobWrapper jobWrapper, GitSCM git, Map<String, String> paramList, EnvVars environment, RemoteConfig repository, URIish remoteURL) throws IOException, InterruptedException {
        boolean isRepoScm = RepoSCM.isRepoSCM(repository.getName());
        FilePathWrapper workspace = this.getWorkspace(jobWrapper, isRepoScm);
        GitClient gitClient = this.getGitClient(jobWrapper, workspace, git, environment);
        this.initWorkspace(workspace, gitClient, remoteURL);
        FetchCommand fetch = gitClient.fetch_().prune().from(remoteURL, repository.getFetchRefSpecs());
        fetch.execute();
        RevisionInfoFactory revisionInfoFactory = new RevisionInfoFactory(gitClient, this.branch);
        List<RevisionInfo> revisions = revisionInfoFactory.getRevisions();
        for (RevisionInfo revision : revisions) {
            paramList.put(revision.getSha1(), revision.getRevisionInfo());
        }
        workspace.delete();
    }

    private void sortAndPutToParam(Set<String> setElement, Map<String, String> paramList) {
        ArrayList<String> sorted = this.sort(setElement);
        for (String element : sorted) {
            paramList.put(element, element);
        }
    }

    private ArrayList<String> sort(Set<String> toSort) {
        ArrayList<String> sorted;
        if (this.getSortMode().getIsSorting()) {
            sorted = this.sortByName(toSort);
            if (this.getSortMode().getIsDescending()) {
                Collections.reverse(sorted);
            }
        } else {
            sorted = new ArrayList<String>(toSort);
        }
        return sorted;
    }

    private FilePathWrapper getWorkspace(JobWrapper jobWrapper, boolean isRepoScm) throws IOException, InterruptedException {
        FilePathWrapper someWorkspace = new FilePathWrapper(jobWrapper.getSomeWorkspace());
        if (isRepoScm) {
            FilePath repoDir = new FilePath(someWorkspace.getFilePath(), RepoSCM.getRepoMainfestsDir());
            someWorkspace = repoDir.exists() ? new FilePathWrapper(repoDir) : this.getTemporaryWorkspace();
        } else if (someWorkspace.getFilePath() == null) {
            someWorkspace = this.getTemporaryWorkspace();
        }
        someWorkspace.getFilePath().mkdirs();
        return someWorkspace;
    }

    private FilePathWrapper getTemporaryWorkspace() throws IOException {
        Path temporaryWorkspacePath = Files.createTempDirectory("git_parameter_", new FileAttribute[0]);
        FilePath filePath = new FilePath(temporaryWorkspacePath.toFile());
        FilePathWrapper filePathWrapper = new FilePathWrapper(filePath);
        filePathWrapper.setThatTemporary();
        return filePathWrapper;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.get() is not null")
    private EnvVars getEnvironment(JobWrapper jobWrapper) throws IOException, InterruptedException {
        EnvVars environment = jobWrapper.getEnvironment(Jenkins.get().toComputer().getNode(), TaskListener.NULL);
        EnvVars buildEnvironment = jobWrapper.getSomeBuildEnvironments();
        this.addEnvironmentIfNotExists(environment, buildEnvironment);
        EnvVars jobDefautEnvironment = this.getJobDefaultEnvironment(jobWrapper);
        this.addEnvironmentIfNotExists(environment, jobDefautEnvironment);
        EnvVars.resolve((Map)environment);
        return environment;
    }

    private void addEnvironmentIfNotExists(EnvVars environment, EnvVars otherEnvironment) {
        if (otherEnvironment == null) {
            return;
        }
        for (Map.Entry entry : otherEnvironment.entrySet()) {
            String key = (String)entry.getKey();
            if (environment.containsKey((Object)key)) continue;
            environment.put(key, (String)entry.getValue());
        }
    }

    private EnvVars getJobDefaultEnvironment(JobWrapper jobWrapper) {
        EnvVars environment = new EnvVars();
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)jobWrapper.getJob().getProperty(ParametersDefinitionProperty.class);
        if (property != null) {
            for (ParameterDefinition parameterDefinition : property.getParameterDefinitions()) {
                if (parameterDefinition == null || !this.isAcceptedParameterClass(parameterDefinition)) continue;
                this.checkAndAddDefaultParameterValue(parameterDefinition, environment);
            }
        }
        return environment;
    }

    private boolean isAcceptedParameterClass(ParameterDefinition parameterDefinition) {
        return parameterDefinition instanceof StringParameterDefinition || parameterDefinition instanceof ChoiceParameterDefinition;
    }

    private void checkAndAddDefaultParameterValue(ParameterDefinition parameterDefinition, EnvVars environment) {
        ParameterValue defaultParameterValue = parameterDefinition.getDefaultParameterValue();
        if (defaultParameterValue != null && defaultParameterValue.getValue() instanceof String) {
            environment.put(parameterDefinition.getName(), (String)defaultParameterValue.getValue());
        }
    }

    private void initWorkspace(FilePathWrapper workspace, GitClient gitClient, URIish remoteURL) throws IOException, InterruptedException {
        if (this.isEmptyWorkspace(workspace.getFilePath())) {
            gitClient.init();
            gitClient.clone(remoteURL.toASCIIString(), "origin", false, null);
            LOGGER.log(Level.INFO, this.getCustomJobName() + " " + Messages.GitParameterDefinition_genContentsCloneDone());
        }
    }

    private boolean isEmptyWorkspace(FilePath workspaceDir) throws IOException, InterruptedException {
        return workspaceDir.list().size() == 0;
    }

    private GitClient getGitClient(JobWrapper jobWrapper, FilePathWrapper workspace, GitSCM git, EnvVars environment) throws IOException, InterruptedException {
        Run build = new Run(jobWrapper.getJob(), System.currentTimeMillis()){};
        return git.createClient(TaskListener.NULL, environment, build, workspace != null ? workspace.getFilePath() : null);
    }

    public ArrayList<String> sortByName(Set<String> set) {
        ArrayList<String> tags = new ArrayList<String>(set);
        if (this.getSortMode().getIsUsingSmartSort()) {
            Collections.sort(tags, new SmartNumberStringComparer());
        } else {
            Collections.sort(tags);
        }
        return tags;
    }

    public String getDivUUID() {
        StringBuilder randomSelectName = new StringBuilder();
        randomSelectName.append(this.getName().replaceAll("\\W", "_")).append("-").append(this.uuid);
        return randomSelectName.toString();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getUseRepository() {
        return this.useRepository;
    }

    public void setUseRepository(String useRepository) {
        this.useRepository = StringUtils.isBlank((String)useRepository) ? null : useRepository;
    }

    public String getCustomJobName() {
        Job job = Utils.getParentJob(this);
        String fullName = job != null ? job.getFullName() : "EMPTY_JOB_NAME";
        return "[ " + fullName + " ] ";
    }

    @Symbol(value={"gitParameter"})
    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private boolean showNeedToCloneInformation = true;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.GitParameterDefinition_DisplayName();
        }

        public ItemsErrorModel doFillValueItems(@AncestorInPath Job job, @QueryParameter String param) {
            ParameterDefinition def;
            JobWrapper jobWrapper = JobWrapperFactory.createJobWrapper(job);
            ParametersDefinitionProperty prop = jobWrapper.getProperty(ParametersDefinitionProperty.class);
            if (prop != null && (def = prop.getParameterDefinition(param)) instanceof GitParameterDefinition) {
                GitParameterDefinition paramDef = (GitParameterDefinition)def;
                String repositoryName = paramDef.getUseRepository();
                List<GitSCM> scms = SCMFactory.getGitSCMs(jobWrapper, repositoryName);
                if (scms == null || scms.isEmpty()) {
                    String useRepositoryMessage = this.getUseRepositoryMessage(repositoryName);
                    return ItemsErrorModel.create(paramDef.getDefaultValue(), Messages.GitParameterDefinition_returnDefaultValue(), Messages.GitParameterDefinition_noRepositoryConfigured(), useRepositoryMessage, Messages.GitParameterDefinition_checkConfiguration());
                }
                return paramDef.generateContents(jobWrapper, scms);
            }
            return ItemsErrorModel.EMPTY;
        }

        private String getUseRepositoryMessage(String repositoryName) {
            return StringUtils.isNotBlank((String)repositoryName) ? Messages.GitParameterDefinition_useRepositoryMessage(repositoryName) : "";
        }

        public FormValidation doCheckDefaultValue(@QueryParameter String defaultValue, @QueryParameter Boolean requiredParameter) {
            if (BooleanUtils.isTrue((Boolean)requiredParameter)) {
                return StringUtils.isBlank((String)defaultValue) ? FormValidation.ok() : FormValidation.warning((String)Messages.GitParameterDefinition_defaultRequiredParameterWarning());
            }
            return StringUtils.isBlank((String)defaultValue) ? FormValidation.warning((String)Messages.GitParameterDefinition_requiredDefaultValue()) : FormValidation.ok();
        }

        public FormValidation doCheckBranchFilter(@QueryParameter String value) {
            String errorMessage = Messages.GitParameterDefinition_invalidBranchPattern(value);
            return this.validationRegularExpression(value, errorMessage);
        }

        public FormValidation doCheckUseRepository(@QueryParameter String value) {
            String errorMessage = Messages.GitParameterDefinition_invalidUseRepositoryPattern(value);
            return this.validationRegularExpression(value, errorMessage);
        }

        private FormValidation validationRegularExpression(String value, String errorMessage) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                LOGGER.log(Level.WARNING, errorMessage, e);
                return FormValidation.error((String)errorMessage);
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.showNeedToCloneInformation = json.getBoolean("showNeedToCloneInformation");
            this.save();
            return super.configure(req, json);
        }

        public boolean getShowNeedToCloneInformation() {
            return this.showNeedToCloneInformation;
        }
    }
}

