/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter;

import hudson.model.Job;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TopLevelItem;
import java.util.List;
import jenkins.model.Jenkins;
import net.uaznia.lukanus.hudson.plugins.gitparameter.GitParameterDefinition;

public class Utils {
    public static Job getParentJob(GitParameterDefinition gitParameterDefinition) {
        return Jenkins.get().getAllItems(Job.class).stream().filter(j -> j instanceof TopLevelItem).filter(j -> j.getProperty(ParametersDefinitionProperty.class) != null).filter(j -> Utils.haveThisGitParameterDefinition(j, gitParameterDefinition)).findFirst().orElse(null);
    }

    private static boolean haveThisGitParameterDefinition(Job job, GitParameterDefinition gitParameterDefinition) {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        List parameterDefinitions = property.getParameterDefinitions();
        if (parameterDefinitions != null) {
            return parameterDefinitions.stream().filter(pd -> pd instanceof GitParameterDefinition).anyMatch(pd -> ((GitParameterDefinition)pd).compareTo(gitParameterDefinition) == 0);
        }
        return false;
    }
}

