/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.gradle.plugins.jpi.internal;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.function.Supplier;

public class VersionCalculator {
    private final Clock clock;
    private final Supplier<String> username;

    public VersionCalculator(Clock clock, Supplier<String> username) {
        this.clock = clock;
        this.username = username;
    }

    public VersionCalculator() {
        this(Clock.systemDefaultZone(), new SystemUsernameSupplier());
    }

    public String calculate(String version) {
        String output = version;
        if ("unspecified".equals(output)) {
            output = "1.0-SNAPSHOT";
        }
        if (output.endsWith("-SNAPSHOT")) {
            ZonedDateTime nowUtc = Instant.now(this.clock).with(ChronoField.MILLI_OF_SECOND, 0L).atZone(ZoneOffset.UTC);
            String dt = DateTimeFormatter.ISO_INSTANT.format(nowUtc);
            output = output + String.format(" (private-%s-%s)", dt, this.username.get());
        }
        return output;
    }

    private static class SystemUsernameSupplier
    implements Supplier<String> {
        private SystemUsernameSupplier() {
        }

        @Override
        public String get() {
            return System.getProperty("user.name");
        }
    }
}

