/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jetty.server.Server;
import winstone.HostConfiguration;
import winstone.Launcher;
import winstone.Logger;
import winstone.cmdline.Option;

public class HostGroup {
    private static final String DEFAULT_HOSTNAME = "default";
    private final Server server;
    private Map<String, HostConfiguration> hostConfigs;
    private String defaultHostName;

    public HostGroup(Server server, ClassLoader commonLibCL, File[] commonLibCLPaths, Map args) throws IOException {
        this.server = server;
        this.hostConfigs = new Hashtable<String, HostConfiguration>();
        File webappsDir = Option.WEBAPPS_DIR.get(args);
        this.initHost(webappsDir, DEFAULT_HOSTNAME, commonLibCL, commonLibCLPaths, args);
        this.defaultHostName = DEFAULT_HOSTNAME;
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostGroup.InitSingleComplete", this.hostConfigs.size() + "", this.hostConfigs.keySet() + "");
    }

    public HostConfiguration getHostByName(String hostname) {
        HostConfiguration host;
        if (hostname != null && this.hostConfigs.size() > 1 && (host = this.hostConfigs.get(hostname)) != null) {
            return host;
        }
        return this.hostConfigs.get(this.defaultHostName);
    }

    protected void initHost(File webappsDir, String hostname, ClassLoader commonLibCL, File[] commonLibCLPaths, Map args) throws IOException {
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostGroup.DeployingHost", (Object)hostname);
        HostConfiguration config = new HostConfiguration(this.server, hostname, commonLibCL, commonLibCLPaths, args, webappsDir);
        this.hostConfigs.put(hostname, config);
    }
}

