/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class ServerConnectorBuilder {
    private int listenerPort;
    private int keepAliveTimeout;
    private int acceptors;
    private int selectors;
    private int requestHeaderSize;
    private String listenerAddress;
    private Server server;
    private SslContextFactory sslContextFactory;

    ServerConnectorBuilder() {
    }

    public ServerConnectorBuilder withListenerPort(int listenerPort) {
        this.listenerPort = listenerPort;
        return this;
    }

    public ServerConnectorBuilder withKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
        return this;
    }

    public ServerConnectorBuilder withListenerAddress(String listenerAddress) {
        this.listenerAddress = listenerAddress;
        return this;
    }

    public ServerConnectorBuilder withServer(Server server) {
        this.server = server;
        return this;
    }

    public ServerConnectorBuilder withAcceptors(int acceptors) {
        this.acceptors = acceptors;
        return this;
    }

    public ServerConnectorBuilder withSelectors(int selectors) {
        this.selectors = selectors;
        return this;
    }

    public ServerConnectorBuilder withSslContext(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
        return this;
    }

    public ServerConnectorBuilder withRequestHeaderSize(int requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
        return this;
    }

    public ServerConnector build() {
        ServerConnector sc = this.sslContextFactory != null ? new ServerConnector(this.server, this.acceptors, this.selectors, this.sslContextFactory) : new ServerConnector(this.server, this.acceptors, this.selectors);
        sc.setPort(this.listenerPort);
        sc.setHost(this.listenerAddress);
        sc.setIdleTimeout(this.keepAliveTimeout);
        HttpConfiguration hc = sc.getConnectionFactory(HttpConnectionFactory.class).getHttpConfiguration();
        hc.addCustomizer(new ForwardedRequestCustomizer());
        hc.setRequestHeaderSize(this.requestHeaderSize);
        return sc;
    }
}

