/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jenkinsci.plugins.kubernetes.credentials.HttpClientWithTLSOptionsFactory;
import org.jenkinsci.plugins.kubernetes.credentials.TokenProducer;
import org.kohsuke.stapler.DataBoundConstructor;

public class OpenShiftBearerTokenCredentialImpl
extends UsernamePasswordCredentialsImpl
implements TokenProducer {
    protected static final long EARLY_EXPIRE_DELAY_SEC = 300L;
    private static final long serialVersionUID = 6031616605797622926L;
    private static final Logger logger = Logger.getLogger(OpenShiftBearerTokenCredentialImpl.class.getName());
    private transient ConcurrentMap<String, Token> tokenCache = new ConcurrentHashMap<String, Token>();

    @DataBoundConstructor
    public OpenShiftBearerTokenCredentialImpl(CredentialsScope scope, String id, String description, String username, String password) {
        super(scope, id, description, username, password);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Other values can be discarded")
    protected static Token extractTokenFromLocation(String location) throws TokenResponseError {
        String parameters = location.substring(location.indexOf(35) + 1);
        List pairs = URLEncodedUtils.parse((String)parameters, (Charset)StandardCharsets.UTF_8);
        String error = "";
        String errorDescription = "";
        Token token = new Token();
        for (NameValuePair pair : pairs) {
            switch (pair.getName()) {
                case "access_token": {
                    token.value = pair.getValue();
                    break;
                }
                case "expires_in": {
                    try {
                        token.expire = System.currentTimeMillis() + (Long.parseLong(pair.getValue()) - 300L) * 1000L;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new TokenResponseError("Bad format for the token expiration value: " + pair.getValue());
                    }
                }
                case "error": {
                    error = pair.getValue();
                    break;
                }
                case "error_description": {
                    errorDescription = pair.getValue();
                }
            }
        }
        if (!error.isEmpty() || !errorDescription.isEmpty()) {
            throw new TokenResponseError("An error was returned instead of a token: " + error + ", " + errorDescription);
        }
        if (token.value == null || token.value.isEmpty()) {
            throw new TokenResponseError("The response contained no token");
        }
        return token;
    }

    protected static String getBasicAuthenticationHeader(String username, Secret password) {
        return "Basic " + Base64.encodeBase64String((byte[])(username + ':' + Secret.toString((Secret)password)).getBytes(StandardCharsets.UTF_8));
    }

    private Object readResolve() {
        this.tokenCache = new ConcurrentHashMap<String, Token>();
        return this;
    }

    @Override
    public String getToken(String oauthServerURL, String caCertData, boolean skipTlsVerify) throws IOException {
        Token token = (Token)this.tokenCache.get(oauthServerURL);
        if (token == null || System.currentTimeMillis() > token.expire) {
            try {
                token = this.refreshToken(oauthServerURL, caCertData, skipTlsVerify);
            }
            catch (HttpClientWithTLSOptionsFactory.TLSConfigurationError e) {
                throw new IOException("Could not configure SSL Factory in HttpClientWithTLSOptionsFactory: " + e.getMessage(), e);
            }
            catch (URISyntaxException e) {
                throw new IOException("The OAuth server URL was invalid ('" + oauthServerURL + "'): " + e.getMessage(), e);
            }
            catch (TokenResponseError e) {
                throw new IOException("The response from the OAuth server was invalid: " + e.getMessage(), e);
            }
            this.tokenCache.put(oauthServerURL, token);
        }
        return token.value;
    }

    private synchronized Token refreshToken(String oauthServerURL, String caCertData, boolean skipTLSVerify) throws URISyntaxException, HttpClientWithTLSOptionsFactory.TLSConfigurationError, TokenResponseError, IOException {
        URI uri = new URI(oauthServerURL);
        HttpClientBuilder builder = HttpClientWithTLSOptionsFactory.getBuilder(uri, caCertData, skipTLSVerify);
        HttpGet authorize = new HttpGet(oauthServerURL + "/oauth/authorize?client_id=openshift-challenging-client&response_type=token");
        authorize.setHeader("Authorization", OpenShiftBearerTokenCredentialImpl.getBasicAuthenticationHeader(this.getUsername(), this.getPassword()));
        CloseableHttpResponse response = builder.build().execute((HttpUriRequest)authorize);
        if (response.getStatusLine().getStatusCode() != 302) {
            throw new TokenResponseError("The OAuth service didn't respond with a redirection but with '" + response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase() + "'");
        }
        Header location = response.getFirstHeader("Location");
        if (location == null) {
            throw new TokenResponseError("The OAuth service didn't respond with location header");
        }
        return OpenShiftBearerTokenCredentialImpl.extractTokenFromLocation(location.getValue());
    }

    public static class TokenResponseError
    extends Exception {
        public TokenResponseError(String message) {
            super(message);
        }
    }

    public static class Token {
        String value;
        long expire;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "OpenShift Username and Password";
        }
    }
}

