/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public class ModelASTWhen
extends ModelASTElement {
    private List<ModelASTStep> conditions = new ArrayList<ModelASTStep>();

    public ModelASTWhen(Object sourceLocation) {
        super(sourceLocation);
    }

    public List<ModelASTStep> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ModelASTStep> conditions) {
        this.conditions = conditions;
    }

    @Override
    public Object toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTStep c : this.conditions) {
            a.add((Object)c.toJSON());
        }
        return new JSONObject().accumulate("conditions", (Object)a);
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("when {\n");
        for (ModelASTStep c : this.conditions) {
            result.append(c.toGroovy()).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTStep c : this.conditions) {
            c.removeSourceLocation();
        }
    }

    @Override
    public String toString() {
        return "ModelASTWhen{conditions=" + this.conditions + "}";
    }

    @Override
    public void validate(ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTStep s : this.conditions) {
            validator.validateWhenCondition(s);
        }
    }
}

