/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTEnvironment;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTOptions;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPostStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStageInput;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTools;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhen;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTStage
extends ModelASTElement {
    protected String name;
    protected ModelASTAgent agent;
    protected ModelASTPostStage post;
    protected ModelASTWhen when;
    protected ModelASTTools tools;
    protected ModelASTEnvironment environment;
    private ModelASTStages stages;
    private List<ModelASTBranch> branches = new ArrayList<ModelASTBranch>();
    private Boolean failFast;
    private ModelASTOptions options;
    private ModelASTStageInput input;
    @Deprecated
    private transient ModelASTStages parallel;
    private List<ModelASTStage> parallelContent = new ArrayList<ModelASTStage>();

    public ModelASTStage(Object sourceLocation) {
        super(sourceLocation);
    }

    protected Object readResolve() throws IOException {
        if (this.parallel != null) {
            if (this.parallelContent == null) {
                this.parallelContent = new ArrayList<ModelASTStage>();
            }
            this.parallelContent.addAll(this.parallel.getStages());
            this.parallel = null;
        }
        return this;
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.accumulate("name", (Object)this.name);
        if (this.agent != null) {
            o.accumulate("agent", (Object)this.agent.toJSON());
        }
        if (this.when != null) {
            o.accumulate("when", this.when.toJSON());
        }
        if (this.post != null) {
            o.accumulate("post", (Object)this.post.toJSON());
        }
        if (this.tools != null) {
            o.accumulate("tools", (Object)this.tools.toJSON());
        }
        if (this.environment != null) {
            o.accumulate("environment", (Object)this.environment.toJSON());
        }
        if (this.options != null) {
            o.accumulate("options", (Object)this.options.toJSON());
        }
        if (this.input != null) {
            o.accumulate("input", (Object)this.input.toJSON());
        }
        if (this.stages != null) {
            o.accumulate("stages", (Object)this.stages.toJSON());
        }
        if (this.branches.isEmpty()) {
            if (!this.parallelContent.isEmpty()) {
                JSONArray a = new JSONArray();
                for (ModelASTStage content : this.parallelContent) {
                    a.add((Object)content.toJSON());
                }
                o.accumulate("parallel", (Object)a);
            }
        } else {
            JSONArray a = new JSONArray();
            for (ModelASTBranch branch : this.branches) {
                a.add((Object)branch.toJSON());
            }
            o.accumulate("branches", (Object)a);
        }
        if (this.failFast != null) {
            o.accumulate("failFast", (Object)this.failFast);
        }
        return o;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        this.validate(validator, false);
    }

    public void validate(ModelValidator validator, boolean isNested) {
        validator.validateElement(this, isNested);
        if (this.agent != null) {
            this.agent.validate(validator);
        }
        if (this.when != null) {
            this.when.validate(validator);
        }
        if (this.post != null) {
            this.post.validate(validator);
        }
        if (this.tools != null) {
            this.tools.validate(validator);
        }
        if (this.environment != null) {
            this.environment.validate(validator);
        }
        if (this.options != null) {
            this.options.validate(validator);
        }
        if (this.input != null) {
            this.input.validate(validator);
        }
        if (this.stages != null) {
            this.stages.validate(validator, true);
        }
        for (ModelASTBranch branch : this.branches) {
            branch.validate(validator);
        }
        for (ModelASTStage content : this.parallelContent) {
            content.validate(validator, true);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        result.append("stage('").append(this.name.replace("'", "\\'")).append("') {\n");
        if (this.agent != null) {
            result.append(this.agent.toGroovy());
        }
        if (this.when != null) {
            result.append(this.when.toGroovy());
        }
        if (this.tools != null) {
            result.append(this.tools.toGroovy());
        }
        if (this.environment != null) {
            result.append(this.environment.toGroovy());
        }
        if (this.options != null) {
            result.append(this.options.toGroovy());
        }
        if (this.input != null) {
            result.append(this.input.toGroovy());
        }
        if (this.post != null) {
            result.append(this.post.toGroovy());
        }
        if (this.stages != null) {
            result.append("stages {\n");
            result.append(this.stages.toGroovy());
            result.append("}\n");
        }
        if (this.branches.isEmpty()) {
            if (this.failFast != null && this.failFast.booleanValue()) {
                result.append("failFast true\n");
            }
            if (!this.parallelContent.isEmpty()) {
                result.append("parallel {\n");
                for (ModelASTStage content : this.parallelContent) {
                    result.append(content.toGroovy());
                }
                result.append("}\n");
            }
        } else {
            result.append("steps {\n");
            if (this.branches.size() > 1) {
                result.append("parallel(");
                boolean first = true;
                for (ModelASTBranch branch : this.branches) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(',');
                    }
                    result.append('\n');
                    result.append('\"' + StringEscapeUtils.escapeJava((String)branch.getName()) + '\"').append(": {\n").append(branch.toGroovy()).append("\n}");
                }
                if (this.failFast != null && this.failFast.booleanValue()) {
                    result.append(",\nfailFast: true");
                }
                result.append("\n)\n");
            } else if (this.branches.size() == 1) {
                result.append(this.branches.get(0).toGroovy());
            }
            result.append("}\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        if (this.agent != null) {
            this.agent.removeSourceLocation();
        }
        if (this.when != null) {
            this.when.removeSourceLocation();
        }
        if (this.post != null) {
            this.post.removeSourceLocation();
        }
        if (this.tools != null) {
            this.tools.removeSourceLocation();
        }
        if (this.environment != null) {
            this.environment.removeSourceLocation();
        }
        if (this.options != null) {
            this.options.removeSourceLocation();
        }
        if (this.input != null) {
            this.input.removeSourceLocation();
        }
        if (this.stages != null) {
            this.stages.removeSourceLocation();
        }
        for (ModelASTBranch branch : this.branches) {
            branch.removeSourceLocation();
        }
        if (this.parallel != null) {
            this.parallel.removeSourceLocation();
        }
        for (ModelASTStage content : this.parallelContent) {
            content.removeSourceLocation();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelASTAgent getAgent() {
        return this.agent;
    }

    public void setAgent(ModelASTAgent agent) {
        this.agent = agent;
    }

    public ModelASTPostStage getPost() {
        return this.post;
    }

    public void setPost(ModelASTPostStage post) {
        this.post = post;
    }

    public ModelASTWhen getWhen() {
        return this.when;
    }

    public void setWhen(ModelASTWhen when) {
        this.when = when;
    }

    public ModelASTTools getTools() {
        return this.tools;
    }

    public void setTools(ModelASTTools tools) {
        this.tools = tools;
    }

    public ModelASTEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ModelASTEnvironment environment) {
        this.environment = environment;
    }

    public ModelASTStages getStages() {
        return this.stages;
    }

    public void setStages(ModelASTStages stages) {
        this.stages = stages;
    }

    public List<ModelASTBranch> getBranches() {
        return this.branches;
    }

    public void setBranches(List<ModelASTBranch> branches) {
        this.branches = branches;
    }

    public Boolean getFailFast() {
        return this.failFast;
    }

    public void setFailFast(Boolean f) {
        this.failFast = f;
    }

    @Deprecated
    public ModelASTStages getParallel() {
        return this.parallel;
    }

    @Deprecated
    public void setParallel(ModelASTStages s) {
        this.parallel = s;
    }

    public ModelASTOptions getOptions() {
        return this.options;
    }

    public void setOptions(ModelASTOptions options) {
        this.options = options;
    }

    public ModelASTStageInput getInput() {
        return this.input;
    }

    public void setInput(ModelASTStageInput input) {
        this.input = input;
    }

    public List<ModelASTStage> getParallelContent() {
        return this.parallelContent;
    }

    public void setParallelContent(List<ModelASTStage> parallelContent) {
        this.parallelContent = parallelContent;
    }

    @Override
    public String toString() {
        return "ModelASTStage{name='" + this.name + '\'' + ", agent=" + this.agent + ", when=" + this.when + ", post=" + this.post + ", tools=" + this.tools + ", environment=" + this.environment + ", stages=" + this.stages + ", branches=" + this.branches + ", failFast=" + this.failFast + ", parallel=" + this.parallel + ", options=" + this.options + ", input=" + this.input + ", parallelContent=" + this.parallelContent + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTStage that = (ModelASTStage)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getAgent() != null ? !this.getAgent().equals(that.getAgent()) : that.getAgent() != null) {
            return false;
        }
        if (this.getPost() != null ? !this.getPost().equals(that.getPost()) : that.getPost() != null) {
            return false;
        }
        if (this.getWhen() != null ? !this.getWhen().equals(that.getWhen()) : that.getWhen() != null) {
            return false;
        }
        if (this.getTools() != null ? !this.getTools().equals(that.getTools()) : that.getTools() != null) {
            return false;
        }
        if (this.getEnvironment() != null ? !this.getEnvironment().equals(that.getEnvironment()) : that.getEnvironment() != null) {
            return false;
        }
        if (this.getOptions() != null ? !this.getOptions().equals(that.getOptions()) : that.getOptions() != null) {
            return false;
        }
        if (this.getInput() != null ? !this.getInput().equals(that.getInput()) : that.getInput() != null) {
            return false;
        }
        if (this.getStages() != null ? !this.getStages().equals(that.getStages()) : that.getStages() != null) {
            return false;
        }
        if (this.getFailFast() != null ? !this.getFailFast().equals(that.getFailFast()) : that.getFailFast() != null) {
            return false;
        }
        if (this.getParallel() != null ? !this.getParallel().equals(that.getParallel()) : that.getParallel() != null) {
            return false;
        }
        if (this.getParallelContent() != null ? !this.getParallelContent().equals(that.getParallelContent()) : that.getParallelContent() != null) {
            return false;
        }
        return this.getBranches() != null ? this.getBranches().equals(that.getBranches()) : that.getBranches() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getAgent() != null ? this.getAgent().hashCode() : 0);
        result = 31 * result + (this.getWhen() != null ? this.getWhen().hashCode() : 0);
        result = 31 * result + (this.getPost() != null ? this.getPost().hashCode() : 0);
        result = 31 * result + (this.getTools() != null ? this.getTools().hashCode() : 0);
        result = 31 * result + (this.getEnvironment() != null ? this.getEnvironment().hashCode() : 0);
        result = 31 * result + (this.getStages() != null ? this.getStages().hashCode() : 0);
        result = 31 * result + (this.getBranches() != null ? this.getBranches().hashCode() : 0);
        result = 31 * result + (this.getFailFast() != null ? this.getFailFast().hashCode() : 0);
        result = 31 * result + (this.getParallel() != null ? this.getParallel().hashCode() : 0);
        result = 31 * result + (this.getOptions() != null ? this.getOptions().hashCode() : 0);
        result = 31 * result + (this.getInput() != null ? this.getInput().hashCode() : 0);
        result = 31 * result + (this.getParallelContent() != null ? this.getParallelContent().hashCode() : 0);
        return result;
    }
}

