/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTLibraries
extends ModelASTElement {
    private List<ModelASTValue> libs = new ArrayList<ModelASTValue>();

    public ModelASTLibraries(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTValue v : this.libs) {
            a.add((Object)v.toJSON());
        }
        return new JSONObject().accumulate("libraries", (Object)a);
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTValue v : this.libs) {
            v.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("libraries {\n");
        for (ModelASTValue v : this.libs) {
            result.append("lib(").append(v.toGroovy()).append(")\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTValue v : this.libs) {
            v.removeSourceLocation();
        }
    }

    public List<ModelASTValue> getLibs() {
        return this.libs;
    }

    public void setLibs(List<ModelASTValue> libs) {
        this.libs = libs;
    }

    @Override
    public String toString() {
        return "ModelASTLibraries{libs=" + this.libs + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTLibraries that = (ModelASTLibraries)o;
        return this.getLibs() != null ? this.getLibs().equals(that.getLibs()) : that.getLibs() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getLibs() != null ? this.getLibs().hashCode() : 0);
        return result;
    }
}

