/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTClosureMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMethodArg;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTAgent
extends ModelASTElement {
    private ModelASTMethodArg variables;
    private ModelASTKey agentType;

    public ModelASTAgent(Object sourceLocation) {
        super(sourceLocation);
    }

    @Nonnull
    public JSONObject toJSON() {
        JSONObject j = new JSONObject();
        if (this.isEmptyStringLabelAgent()) {
            j.accumulate("type", (Object)"any");
        } else {
            j.accumulate("type", ModelASTAgent.toJSON(this.agentType));
            if (this.variables instanceof ModelASTClosureMap) {
                j.elementOpt("arguments", (Object)ModelASTAgent.nullIfEmpty((JSONArray)this.variables.toJSON()));
            } else if (this.variables instanceof ModelASTValue) {
                j.elementOpt("argument", this.variables.toJSON());
            }
        }
        return j;
    }

    private boolean isEmptyStringLabelAgent() {
        if (this.agentType.getKey().equals("label") || this.agentType.getKey().equals("node")) {
            Map<ModelASTKey, ModelASTMethodArg> vars;
            if (this.variables instanceof ModelASTValue && "".equals(((ModelASTValue)this.variables).getValue())) {
                return true;
            }
            if (this.variables instanceof ModelASTClosureMap && (vars = ((ModelASTClosureMap)this.variables).getVariables()).size() == 1) {
                for (Map.Entry<ModelASTKey, ModelASTMethodArg> entry : vars.entrySet()) {
                    ModelASTMethodArg argValue;
                    if (!entry.getKey().getKey().equals("label") || !((argValue = entry.getValue()) instanceof ModelASTValue) || !((ModelASTValue)argValue).getValue().equals("")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        ModelASTAgent.validate(validator, this.variables);
    }

    @Override
    @Nonnull
    public String toGroovy() {
        StringBuilder argStr = new StringBuilder();
        if (this.variables == null || this.variables instanceof ModelASTClosureMap && ((ModelASTClosureMap)this.variables).getVariables().isEmpty()) {
            argStr.append(this.agentType.toGroovy());
        } else {
            argStr.append("{\n");
            argStr.append(this.agentType.toGroovy());
            argStr.append(" ");
            argStr.append(this.variables.toGroovy());
            argStr.append("\n}");
        }
        return "agent " + argStr.toString() + "\n";
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        ModelASTAgent.removeSourceLocationsFrom(this.agentType, this.variables);
    }

    public ModelASTKey getAgentType() {
        return this.agentType;
    }

    public void setAgentType(ModelASTKey k) {
        this.agentType = k;
    }

    public ModelASTMethodArg getVariables() {
        return this.variables;
    }

    public void setVariables(ModelASTMethodArg variables) {
        this.variables = variables;
    }

    @Override
    public String toString() {
        return "ModelASTAgent{agentType=" + this.agentType + "variables=" + this.variables + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTAgent that = (ModelASTAgent)o;
        if (this.getAgentType() != null ? !this.getAgentType().equals(that.getAgentType()) : that.getAgentType() != null) {
            return false;
        }
        return this.getVariables() != null ? this.getVariables().equals(that.getVariables()) : that.getVariables() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getAgentType() != null ? this.getAgentType().hashCode() : 0);
        result = 31 * result + (this.getVariables() != null ? this.getVariables().hashCode() : 0);
        return result;
    }
}

