/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTEnvironmentValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMethodArg;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public abstract class ModelASTValue
extends ModelASTElement
implements ModelASTMethodArg,
ModelASTEnvironmentValue {
    private Object value;

    ModelASTValue(Object sourceLocation, Object v) {
        super(sourceLocation);
        this.value = v;
    }

    public abstract boolean isLiteral();

    public Object getValue() {
        return this.value;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
    }

    @Nonnull
    public JSONObject toJSON() {
        return new JSONObject().accumulate("isLiteral", this.isLiteral()).accumulate("value", this.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTValue that = (ModelASTValue)o;
        return this.getValue() != null ? this.getValue().equals(that.getValue()) : that.getValue() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getValue() != null ? this.getValue().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ModelASTValue{value=" + this.value + ", isLiteral=" + this.isLiteral() + '}';
    }

    public static ModelASTValue fromConstant(Object o, Object sourceLocation) {
        return new ConstantValue(sourceLocation, o);
    }

    public static ModelASTValue fromGString(String gstring, Object sourceLocation) {
        return new GStringValue(sourceLocation, gstring);
    }

    private static final class GStringValue
    extends ModelASTValue {
        GStringValue(Object sourceLocation, Object v) {
            super(sourceLocation, v);
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        @Nonnull
        public String toGroovy() {
            String gstring = (String)this.getValue();
            if (gstring.startsWith("${") && gstring.endsWith("}")) {
                return gstring.substring(2, gstring.length() - 1);
            }
            return gstring;
        }
    }

    private static final class ConstantValue
    extends ModelASTValue {
        ConstantValue(Object sourceLocation, Object v) {
            super(sourceLocation, v);
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        @Nonnull
        public String toGroovy() {
            if (this.getValue() instanceof String) {
                String str = (String)this.getValue();
                if ((str = str.replace("\\", "\\\\")).indexOf(10) == -1) {
                    return "'" + str.replace("'", "\\'") + "'";
                }
                return "'''" + str.replace("'", "\\'") + "'''";
            }
            if (this.getValue() != null) {
                return this.getValue().toString();
            }
            return "null";
        }
    }
}

