/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTNamedArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;

public abstract class AbstractModelASTCodeBlock
extends ModelASTStep {
    protected AbstractModelASTCodeBlock(Object sourceLocation, String name) {
        super(sourceLocation);
        this.setName(name);
    }

    @Override
    @NonNull
    public String toGroovy() {
        StringBuilder result = new StringBuilder(this.getName()).append(" {\n");
        result.append(this.codeBlockAsString());
        result.append("\n}\n");
        return result.toString();
    }

    public String codeBlockAsString() {
        if (this.getArgs() == null) {
            return null;
        }
        if (this.isLiteralSingleArg()) {
            Object v = this.getSingleValue().getValue();
            if (v instanceof String) {
                ArrayList<String> retList = new ArrayList<String>();
                for (String s : v.toString().split("\\r?\\n")) {
                    retList.add(s.trim());
                }
                return StringUtils.join(retList, (String)"\n");
            }
            return v.toString();
        }
        return this.getArgs().toGroovy();
    }

    protected ModelASTValue getSingleValue() {
        ModelASTNamedArgumentList namedArgs;
        if (this.getArgs() instanceof ModelASTSingleArgument) {
            return ((ModelASTSingleArgument)this.getArgs()).getValue();
        }
        if (this.getArgs() instanceof ModelASTNamedArgumentList && (namedArgs = (ModelASTNamedArgumentList)this.getArgs()).getArguments().size() == 1 && namedArgs.containsKeyName("scriptBlock")) {
            return namedArgs.valueForName("scriptBlock");
        }
        return null;
    }

    protected boolean isLiteralSingleArg() {
        return this.getArgs() != null && this.getSingleValue() != null && this.getSingleValue().isLiteral();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModelASTCodeBlock that = (AbstractModelASTCodeBlock)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.isLiteralSingleArg() && that.isLiteralSingleArg()) {
            return this.codeBlockAsString().equals(that.codeBlockAsString());
        }
        return this.getArgs() != null ? this.getArgs().equals(that.getArgs()) : that.getArgs() == null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.getName() + "', args=" + this.getArgs() + "}";
    }
}

