// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.modeldefinition;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ModelValidatorImpl.NestedWhenNoArgs}: {@code No additional
     * arguments are allowed for children when condition "{0}".}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No additional arguments are allowed for children when condition
     *     "{0}".}
     */
    public static String ModelValidatorImpl_NestedWhenNoArgs(Object arg0) {
        return holder.format("ModelValidatorImpl.NestedWhenNoArgs", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NestedWhenNoArgs}: {@code No additional
     * arguments are allowed for children when condition "{0}".}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No additional arguments are allowed for children when condition
     *     "{0}".}
     */
    public static Localizable _ModelValidatorImpl_NestedWhenNoArgs(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.NestedWhenNoArgs", arg0);
    }

    /**
     * Key {@code ModelParser.BigIntegerValue}: {@code BigIntegers cannot be
     * used as constants in Declarative. The maximum value for an integer is
     *  9,223,372,036,854,775,807 and the minimum value for an integer is
     * -9,223,372,036,854,775,808.}.
     * 
     * @return
     *     {@code BigIntegers cannot be used as constants in Declarative. The
     *     maximum value for an integer is 9,223,372,036,854,775,807 and the
     *     minimum value for an integer is -9,223,372,036,854,775,808.}
     */
    public static String ModelParser_BigIntegerValue() {
        return holder.format("ModelParser.BigIntegerValue");
    }

    /**
     * Key {@code ModelParser.BigIntegerValue}: {@code BigIntegers cannot be
     * used as constants in Declarative. The maximum value for an integer is
     *  9,223,372,036,854,775,807 and the minimum value for an integer is
     * -9,223,372,036,854,775,808.}.
     * 
     * @return
     *     {@code BigIntegers cannot be used as constants in Declarative. The
     *     maximum value for an integer is 9,223,372,036,854,775,807 and the
     *     minimum value for an integer is -9,223,372,036,854,775,808.}
     */
    public static Localizable _ModelParser_BigIntegerValue() {
        return new Localizable(holder, "ModelParser.BigIntegerValue");
    }

    /**
     * Key {@code ModelParser.InvalidInternalFunctionArg}: {@code Internal
     * function call parameters must be strings.}.
     * 
     * @return
     *     {@code Internal function call parameters must be strings.}
     */
    public static String ModelParser_InvalidInternalFunctionArg() {
        return holder.format("ModelParser.InvalidInternalFunctionArg");
    }

    /**
     * Key {@code ModelParser.InvalidInternalFunctionArg}: {@code Internal
     * function call parameters must be strings.}.
     * 
     * @return
     *     {@code Internal function call parameters must be strings.}
     */
    public static Localizable _ModelParser_InvalidInternalFunctionArg() {
        return new Localizable(holder, "ModelParser.InvalidInternalFunctionArg");
    }

    /**
     * Key {@code ModelParser.TooManyArgsForAgentKey}: {@code Too many
     * arguments for agent key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for agent key "{0}"}
     */
    public static String ModelParser_TooManyArgsForAgentKey(Object arg0) {
        return holder.format("ModelParser.TooManyArgsForAgentKey", arg0);
    }

    /**
     * Key {@code ModelParser.TooManyArgsForAgentKey}: {@code Too many
     * arguments for agent key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for agent key "{0}"}
     */
    public static Localizable _ModelParser_TooManyArgsForAgentKey(Object arg0) {
        return new Localizable(holder, "ModelParser.TooManyArgsForAgentKey", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoToolVersion}: {@code Tool type "{0}"
     * does not have an install of "{1}" configured - did you mean "{2}"?}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Tool type "{0}" does not have an install of "{1}" configured -
     *     did you mean "{2}"?}
     */
    public static String ModelValidatorImpl_NoToolVersion(Object arg0, Object arg1, Object arg2) {
        return holder.format("ModelValidatorImpl.NoToolVersion", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelValidatorImpl.NoToolVersion}: {@code Tool type "{0}"
     * does not have an install of "{1}" configured - did you mean "{2}"?}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Tool type "{0}" does not have an install of "{1}" configured -
     *     did you mean "{2}"?}
     */
    public static Localizable _ModelValidatorImpl_NoToolVersion(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ModelValidatorImpl.NoToolVersion", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelParser.DuplicateEnvVar}: {@code Duplicate environment
     * variable name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate environment variable name: "{0}"}
     */
    public static String ModelParser_DuplicateEnvVar(Object arg0) {
        return holder.format("ModelParser.DuplicateEnvVar", arg0);
    }

    /**
     * Key {@code ModelParser.DuplicateEnvVar}: {@code Duplicate environment
     * variable name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate environment variable name: "{0}"}
     */
    public static Localizable _ModelParser_DuplicateEnvVar(Object arg0) {
        return new Localizable(holder, "ModelParser.DuplicateEnvVar", arg0);
    }

    /**
     * Key {@code ModelParser.BareDollarCurly}: {@code {0} cannot be used as
     * a value directly. Did you mean "{0}"?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} cannot be used as a value directly. Did you mean "{0}"?}
     */
    public static String ModelParser_BareDollarCurly(Object arg0) {
        return holder.format("ModelParser.BareDollarCurly", arg0);
    }

    /**
     * Key {@code ModelParser.BareDollarCurly}: {@code {0} cannot be used as
     * a value directly. Did you mean "{0}"?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} cannot be used as a value directly. Did you mean "{0}"?}
     */
    public static Localizable _ModelParser_BareDollarCurly(Object arg0) {
        return new Localizable(holder, "ModelParser.BareDollarCurly", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.DirSeparatorInDockerfileName}: {@code
     * Dockerfile filename cannot contain directory separators.}.
     * 
     * @return
     *     {@code Dockerfile filename cannot contain directory separators.}
     */
    public static String ModelValidatorImpl_DirSeparatorInDockerfileName() {
        return holder.format("ModelValidatorImpl.DirSeparatorInDockerfileName");
    }

    /**
     * Key {@code ModelValidatorImpl.DirSeparatorInDockerfileName}: {@code
     * Dockerfile filename cannot contain directory separators.}.
     * 
     * @return
     *     {@code Dockerfile filename cannot contain directory separators.}
     */
    public static Localizable _ModelValidatorImpl_DirSeparatorInDockerfileName() {
        return new Localizable(holder, "ModelValidatorImpl.DirSeparatorInDockerfileName");
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateStageName}: {@code Duplicate
     * stage name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate stage name: "{0}"}
     */
    public static String ModelValidatorImpl_DuplicateStageName(Object arg0) {
        return holder.format("ModelValidatorImpl.DuplicateStageName", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateStageName}: {@code Duplicate
     * stage name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate stage name: "{0}"}
     */
    public static Localizable _ModelValidatorImpl_DuplicateStageName(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.DuplicateStageName", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedStep}: {@code Expected a step}.
     * 
     * @return
     *     {@code Expected a step}
     */
    public static String ModelParser_ExpectedStep() {
        return holder.format("ModelParser.ExpectedStep");
    }

    /**
     * Key {@code ModelParser.ExpectedStep}: {@code Expected a step}.
     * 
     * @return
     *     {@code Expected a step}
     */
    public static Localizable _ModelParser_ExpectedStep() {
        return new Localizable(holder, "ModelParser.ExpectedStep");
    }

    /**
     * Key {@code ModelParser.UnknownStageSection}: {@code Unknown stage
     * section "{0}". Starting with version 0.5, steps in a stage must be in
     * a 'steps' block.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown stage section "{0}". Starting with version 0.5, steps
     *     in a stage must be in a 'steps' block.}
     */
    public static String ModelParser_UnknownStageSection(Object arg0) {
        return holder.format("ModelParser.UnknownStageSection", arg0);
    }

    /**
     * Key {@code ModelParser.UnknownStageSection}: {@code Unknown stage
     * section "{0}". Starting with version 0.5, steps in a stage must be in
     * a 'steps' block.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown stage section "{0}". Starting with version 0.5, steps
     *     in a stage must be in a 'steps' block.}
     */
    public static Localizable _ModelParser_UnknownStageSection(Object arg0) {
        return new Localizable(holder, "ModelParser.UnknownStageSection", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoNestedWithinNestedStages}: {@code
     * Parallel stages or branches can only be included in a top-level
     * stage.}.
     * 
     * @return
     *     {@code Parallel stages or branches can only be included in a top-level
     *     stage.}
     */
    public static String ModelValidatorImpl_NoNestedWithinNestedStages() {
        return holder.format("ModelValidatorImpl.NoNestedWithinNestedStages");
    }

    /**
     * Key {@code ModelValidatorImpl.NoNestedWithinNestedStages}: {@code
     * Parallel stages or branches can only be included in a top-level
     * stage.}.
     * 
     * @return
     *     {@code Parallel stages or branches can only be included in a top-level
     *     stage.}
     */
    public static Localizable _ModelValidatorImpl_NoNestedWithinNestedStages() {
        return new Localizable(holder, "ModelValidatorImpl.NoNestedWithinNestedStages");
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateTriggerName}: {@code Duplicate
     * trigger name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate trigger name: "{0}"}
     */
    public static String ModelValidatorImpl_DuplicateTriggerName(Object arg0) {
        return holder.format("ModelValidatorImpl.DuplicateTriggerName", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateTriggerName}: {@code Duplicate
     * trigger name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate trigger name: "{0}"}
     */
    public static Localizable _ModelValidatorImpl_DuplicateTriggerName(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.DuplicateTriggerName", arg0);
    }

    /**
     * Key {@code JSONParser.TooFewItems}: {@code Array has {0} entries,
     * requires minimum of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Array has {0} entries, requires minimum of {1}}
     */
    public static String JSONParser_TooFewItems(Object arg0, Object arg1) {
        return holder.format("JSONParser.TooFewItems", arg0, arg1);
    }

    /**
     * Key {@code JSONParser.TooFewItems}: {@code Array has {0} entries,
     * requires minimum of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Array has {0} entries, requires minimum of {1}}
     */
    public static Localizable _JSONParser_TooFewItems(Object arg0, Object arg1) {
        return new Localizable(holder, "JSONParser.TooFewItems", arg0, arg1);
    }

    /**
     * Key {@code ModelParser.WrongWhenCount}: {@code One condition is
     * required in "when"}.
     * 
     * @return
     *     {@code One condition is required in "when"}
     */
    public static String ModelParser_WrongWhenCount() {
        return holder.format("ModelParser.WrongWhenCount");
    }

    /**
     * Key {@code ModelParser.WrongWhenCount}: {@code One condition is
     * required in "when"}.
     * 
     * @return
     *     {@code One condition is required in "when"}
     */
    public static Localizable _ModelParser_WrongWhenCount() {
        return new Localizable(holder, "ModelParser.WrongWhenCount");
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentConcatValue}: {@code
     * Environment variable values to be concatenated together must be single
     * or double quoted.}.
     * 
     * @return
     *     {@code Environment variable values to be concatenated together must be
     *     single or double quoted.}
     */
    public static String ModelParser_InvalidEnvironmentConcatValue() {
        return holder.format("ModelParser.InvalidEnvironmentConcatValue");
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentConcatValue}: {@code
     * Environment variable values to be concatenated together must be single
     * or double quoted.}.
     * 
     * @return
     *     {@code Environment variable values to be concatenated together must be
     *     single or double quoted.}
     */
    public static Localizable _ModelParser_InvalidEnvironmentConcatValue() {
        return new Localizable(holder, "ModelParser.InvalidEnvironmentConcatValue");
    }

    /**
     * Key {@code ModelParser.ExpectedBlock}: {@code Expected a block}.
     * 
     * @return
     *     {@code Expected a block}
     */
    public static String ModelParser_ExpectedBlock() {
        return holder.format("ModelParser.ExpectedBlock");
    }

    /**
     * Key {@code ModelParser.ExpectedBlock}: {@code Expected a block}.
     * 
     * @return
     *     {@code Expected a block}
     */
    public static Localizable _ModelParser_ExpectedBlock() {
        return new Localizable(holder, "ModelParser.ExpectedBlock");
    }

    /**
     * Key {@code JSONParser.ObjNotJSON}: {@code Object {0} is neither a JSON
     * array nor a JSON object}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Object {0} is neither a JSON array nor a JSON object}
     */
    public static String JSONParser_ObjNotJSON(Object arg0) {
        return holder.format("JSONParser.ObjNotJSON", arg0);
    }

    /**
     * Key {@code JSONParser.ObjNotJSON}: {@code Object {0} is neither a JSON
     * array nor a JSON object}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Object {0} is neither a JSON array nor a JSON object}
     */
    public static Localizable _JSONParser_ObjNotJSON(Object arg0) {
        return new Localizable(holder, "JSONParser.ObjNotJSON", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidParameterType}: {@code Expecting
     * "{0}" for parameter "{1}" but got "{2}" of type {3} instead}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expecting "{0}" for parameter "{1}" but got "{2}" of type {3}
     *     instead}
     */
    public static String ModelValidatorImpl_InvalidParameterType(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("ModelValidatorImpl.InvalidParameterType", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidParameterType}: {@code Expecting
     * "{0}" for parameter "{1}" but got "{2}" of type {3} instead}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expecting "{0}" for parameter "{1}" but got "{2}" of type {3}
     *     instead}
     */
    public static Localizable _ModelValidatorImpl_InvalidParameterType(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidParameterType", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code ModelParser.InvalidBuildCondition}: {@code The 'post'
     * section can only contain build condition names with code blocks. Valid
     * condition names are {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The 'post' section can only contain build condition names with
     *     code blocks. Valid condition names are {0}}
     */
    public static String ModelParser_InvalidBuildCondition(Object arg0) {
        return holder.format("ModelParser.InvalidBuildCondition", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidBuildCondition}: {@code The 'post'
     * section can only contain build condition names with code blocks. Valid
     * condition names are {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The 'post' section can only contain build condition names with
     *     code blocks. Valid condition names are {0}}
     */
    public static Localizable _ModelParser_InvalidBuildCondition(Object arg0) {
        return new Localizable(holder, "ModelParser.InvalidBuildCondition", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedAgentKeyValue}: {@code Expected to find
     * 'key "value"'}.
     * 
     * @return
     *     {@code Expected to find 'key "value"'}
     */
    public static String ModelParser_ExpectedAgentKeyValue() {
        return holder.format("ModelParser.ExpectedAgentKeyValue");
    }

    /**
     * Key {@code ModelParser.ExpectedAgentKeyValue}: {@code Expected to find
     * 'key "value"'}.
     * 
     * @return
     *     {@code Expected to find 'key "value"'}
     */
    public static Localizable _ModelParser_ExpectedAgentKeyValue() {
        return new Localizable(holder, "ModelParser.ExpectedAgentKeyValue");
    }

    /**
     * Key {@code ModelValidatorImpl.NothingForStage}: {@code No "steps" or
     * "parallel" to execute within stage "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No "steps" or "parallel" to execute within stage "{0}"}
     */
    public static String ModelValidatorImpl_NothingForStage(Object arg0) {
        return holder.format("ModelValidatorImpl.NothingForStage", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NothingForStage}: {@code No "steps" or
     * "parallel" to execute within stage "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No "steps" or "parallel" to execute within stage "{0}"}
     */
    public static Localizable _ModelValidatorImpl_NothingForStage(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.NothingForStage", arg0);
    }

    /**
     * Key {@code ModelParser.ObjectMethodCall}: {@code Method calls on
     * objects not allowed outside "script" blocks.}.
     * 
     * @return
     *     {@code Method calls on objects not allowed outside "script" blocks.}
     */
    public static String ModelParser_ObjectMethodCall() {
        return holder.format("ModelParser.ObjectMethodCall");
    }

    /**
     * Key {@code ModelParser.ObjectMethodCall}: {@code Method calls on
     * objects not allowed outside "script" blocks.}.
     * 
     * @return
     *     {@code Method calls on objects not allowed outside "script" blocks.}
     */
    public static Localizable _ModelParser_ObjectMethodCall() {
        return new Localizable(holder, "ModelParser.ObjectMethodCall");
    }

    /**
     * Key {@code ModelValidatorImpl.WrongBuildParameterType}: {@code Invalid
     * type for parameter "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid type for parameter "{0}"}
     */
    public static String ModelValidatorImpl_WrongBuildParameterType(Object arg0) {
        return holder.format("ModelValidatorImpl.WrongBuildParameterType", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.WrongBuildParameterType}: {@code Invalid
     * type for parameter "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid type for parameter "{0}"}
     */
    public static Localizable _ModelValidatorImpl_WrongBuildParameterType(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.WrongBuildParameterType", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentIdentifier}: {@code "{0}" is
     * not a valid environment expression. Use "key = value" pairs with valid
     * Java/shell keys.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is not a valid environment expression. Use "key = value"
     *     pairs with valid Java/shell keys.}
     */
    public static String ModelParser_InvalidEnvironmentIdentifier(Object arg0) {
        return holder.format("ModelParser.InvalidEnvironmentIdentifier", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentIdentifier}: {@code "{0}" is
     * not a valid environment expression. Use "key = value" pairs with valid
     * Java/shell keys.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is not a valid environment expression. Use "key = value"
     *     pairs with valid Java/shell keys.}
     */
    public static Localizable _ModelParser_InvalidEnvironmentIdentifier(Object arg0) {
        return new Localizable(holder, "ModelParser.InvalidEnvironmentIdentifier", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NestedWhenWrongChildrenCount}: {@code
     * Nested when condition "{0}" requires exactly {1} child condition(s).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Nested when condition "{0}" requires exactly {1} child
     *     condition(s).}
     */
    public static String ModelValidatorImpl_NestedWhenWrongChildrenCount(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.NestedWhenWrongChildrenCount", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.NestedWhenWrongChildrenCount}: {@code
     * Nested when condition "{0}" requires exactly {1} child condition(s).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Nested when condition "{0}" requires exactly {1} child
     *     condition(s).}
     */
    public static Localizable _ModelValidatorImpl_NestedWhenWrongChildrenCount(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.NestedWhenWrongChildrenCount", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidIdentifierInEnv}: {@code "{0}" is
     * not a valid identifier and cannot be used for an environment variable.
     * Identifiers must start with a letter or underscore and can contain
     * only letters, numbers or underscores.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is not a valid identifier and cannot be used for an
     *     environment variable. Identifiers must start with a letter or
     *     underscore and can contain only letters, numbers or underscores.}
     */
    public static String ModelValidatorImpl_InvalidIdentifierInEnv(Object arg0) {
        return holder.format("ModelValidatorImpl.InvalidIdentifierInEnv", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidIdentifierInEnv}: {@code "{0}" is
     * not a valid identifier and cannot be used for an environment variable.
     * Identifiers must start with a letter or underscore and can contain
     * only letters, numbers or underscores.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is not a valid identifier and cannot be used for an
     *     environment variable. Identifiers must start with a letter or
     *     underscore and can contain only letters, numbers or underscores.}
     */
    public static Localizable _ModelValidatorImpl_InvalidIdentifierInEnv(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidIdentifierInEnv", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidStepParameter}: {@code Invalid
     * parameter "{0}", did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid parameter "{0}", did you mean "{1}"?}
     */
    public static String ModelValidatorImpl_InvalidStepParameter(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.InvalidStepParameter", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidStepParameter}: {@code Invalid
     * parameter "{0}", did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid parameter "{0}", did you mean "{1}"?}
     */
    public static Localizable _ModelValidatorImpl_InvalidStepParameter(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidStepParameter", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.TooManyUnnamedParameters}: {@code
     * Arguments to "{0}" must be explicitly named.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Arguments to "{0}" must be explicitly named.}
     */
    public static String ModelValidatorImpl_TooManyUnnamedParameters(Object arg0) {
        return holder.format("ModelValidatorImpl.TooManyUnnamedParameters", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.TooManyUnnamedParameters}: {@code
     * Arguments to "{0}" must be explicitly named.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Arguments to "{0}" must be explicitly named.}
     */
    public static Localizable _ModelValidatorImpl_TooManyUnnamedParameters(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.TooManyUnnamedParameters", arg0);
    }

    /**
     * Key {@code ModelParser.CannotHaveBlocks}: {@code {0} definitions
     * cannot have blocks}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} definitions cannot have blocks}
     */
    public static String ModelParser_CannotHaveBlocks(Object arg0) {
        return holder.format("ModelParser.CannotHaveBlocks", arg0);
    }

    /**
     * Key {@code ModelParser.CannotHaveBlocks}: {@code {0} definitions
     * cannot have blocks}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} definitions cannot have blocks}
     */
    public static Localizable _ModelParser_CannotHaveBlocks(Object arg0) {
        return new Localizable(holder, "ModelParser.CannotHaveBlocks", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidSectionDefinition}: {@code Not a valid
     * section definition: "{0}". Some extra configuration is required.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not a valid section definition: "{0}". Some extra configuration
     *     is required.}
     */
    public static String ModelParser_InvalidSectionDefinition(Object arg0) {
        return holder.format("ModelParser.InvalidSectionDefinition", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidSectionDefinition}: {@code Not a valid
     * section definition: "{0}". Some extra configuration is required.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not a valid section definition: "{0}". Some extra configuration
     *     is required.}
     */
    public static Localizable _ModelParser_InvalidSectionDefinition(Object arg0) {
        return new Localizable(holder, "ModelParser.InvalidSectionDefinition", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidBuildCondition}: {@code Invalid
     * condition "{0}" - valid conditions are {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid condition "{0}" - valid conditions are {1}}
     */
    public static String ModelValidatorImpl_InvalidBuildCondition(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.InvalidBuildCondition", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidBuildCondition}: {@code Invalid
     * condition "{0}" - valid conditions are {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid condition "{0}" - valid conditions are {1}}
     */
    public static Localizable _ModelValidatorImpl_InvalidBuildCondition(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidBuildCondition", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.EmptyWhen}: {@code Empty when closure,
     * remove the property or add some content.}.
     * 
     * @return
     *     {@code Empty when closure, remove the property or add some content.}
     */
    public static String ModelValidatorImpl_EmptyWhen() {
        return holder.format("ModelValidatorImpl.EmptyWhen");
    }

    /**
     * Key {@code ModelValidatorImpl.EmptyWhen}: {@code Empty when closure,
     * remove the property or add some content.}.
     * 
     * @return
     *     {@code Empty when closure, remove the property or add some content.}
     */
    public static Localizable _ModelValidatorImpl_EmptyWhen() {
        return new Localizable(holder, "ModelValidatorImpl.EmptyWhen");
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentOperation}: {@code
     * Environment variable values can only be joined together with '+'s.}.
     * 
     * @return
     *     {@code Environment variable values can only be joined together with
     *     '+'s.}
     */
    public static String ModelParser_InvalidEnvironmentOperation() {
        return holder.format("ModelParser.InvalidEnvironmentOperation");
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentOperation}: {@code
     * Environment variable values can only be joined together with '+'s.}.
     * 
     * @return
     *     {@code Environment variable values can only be joined together with
     *     '+'s.}
     */
    public static Localizable _ModelParser_InvalidEnvironmentOperation() {
        return new Localizable(holder, "ModelParser.InvalidEnvironmentOperation");
    }

    /**
     * Key {@code Parser.Options}: {@code Options}.
     * 
     * @return
     *     {@code Options}
     */
    public static String Parser_Options() {
        return holder.format("Parser.Options");
    }

    /**
     * Key {@code Parser.Options}: {@code Options}.
     * 
     * @return
     *     {@code Options}
     */
    public static Localizable _Parser_Options() {
        return new Localizable(holder, "Parser.Options");
    }

    /**
     * Key {@code ModelValidatorImpl.NestedWhenWithoutChildren}: {@code
     * Nested when condition "{0}" requires at least one child condition.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Nested when condition "{0}" requires at least one child
     *     condition.}
     */
    public static String ModelValidatorImpl_NestedWhenWithoutChildren(Object arg0) {
        return holder.format("ModelValidatorImpl.NestedWhenWithoutChildren", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NestedWhenWithoutChildren}: {@code
     * Nested when condition "{0}" requires at least one child condition.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Nested when condition "{0}" requires at least one child
     *     condition.}
     */
    public static Localizable _ModelValidatorImpl_NestedWhenWithoutChildren(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.NestedWhenWithoutChildren", arg0);
    }

    /**
     * Key {@code JSONParser.InvalidValueType}: {@code Invalid value type}.
     * 
     * @return
     *     {@code Invalid value type}
     */
    public static String JSONParser_InvalidValueType() {
        return holder.format("JSONParser.InvalidValueType");
    }

    /**
     * Key {@code JSONParser.InvalidValueType}: {@code Invalid value type}.
     * 
     * @return
     *     {@code Invalid value type}
     */
    public static Localizable _JSONParser_InvalidValueType() {
        return new Localizable(holder, "JSONParser.InvalidValueType");
    }

    /**
     * Key {@code ModelValidatorImpl.UnknownWhenConditional}: {@code Unknown
     * conditional {0}. Valid conditionals are: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown conditional {0}. Valid conditionals are: {1}}
     */
    public static String ModelValidatorImpl_UnknownWhenConditional(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.UnknownWhenConditional", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.UnknownWhenConditional}: {@code Unknown
     * conditional {0}. Valid conditionals are: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown conditional {0}. Valid conditionals are: {1}}
     */
    public static Localizable _ModelValidatorImpl_UnknownWhenConditional(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.UnknownWhenConditional", arg0, arg1);
    }

    /**
     * Key {@code Parser.Triggers}: {@code Triggers}.
     * 
     * @return
     *     {@code Triggers}
     */
    public static String Parser_Triggers() {
        return holder.format("Parser.Triggers");
    }

    /**
     * Key {@code Parser.Triggers}: {@code Triggers}.
     * 
     * @return
     *     {@code Triggers}
     */
    public static Localizable _Parser_Triggers() {
        return new Localizable(holder, "Parser.Triggers");
    }

    /**
     * Key {@code ModelValidatorImpl.RequiredSection}: {@code Missing
     * required section "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing required section "{0}"}
     */
    public static String ModelValidatorImpl_RequiredSection(Object arg0) {
        return holder.format("ModelValidatorImpl.RequiredSection", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.RequiredSection}: {@code Missing
     * required section "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing required section "{0}"}
     */
    public static Localizable _ModelValidatorImpl_RequiredSection(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.RequiredSection", arg0);
    }

    /**
     * Key {@code ModelParser.TooManyArgsForMapMethodKey}: {@code Too many
     * arguments for map key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for map key "{0}"}
     */
    public static String ModelParser_TooManyArgsForMapMethodKey(Object arg0) {
        return holder.format("ModelParser.TooManyArgsForMapMethodKey", arg0);
    }

    /**
     * Key {@code ModelParser.TooManyArgsForMapMethodKey}: {@code Too many
     * arguments for map key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for map key "{0}"}
     */
    public static Localizable _ModelParser_TooManyArgsForMapMethodKey(Object arg0) {
        return new Localizable(holder, "ModelParser.TooManyArgsForMapMethodKey", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentValue}: {@code Environment
     * variable values must either be single quoted, double quoted, or
     * function calls.}.
     * 
     * @return
     *     {@code Environment variable values must either be single quoted,
     *     double quoted, or function calls.}
     */
    public static String ModelParser_InvalidEnvironmentValue() {
        return holder.format("ModelParser.InvalidEnvironmentValue");
    }

    /**
     * Key {@code ModelParser.InvalidEnvironmentValue}: {@code Environment
     * variable values must either be single quoted, double quoted, or
     * function calls.}.
     * 
     * @return
     *     {@code Environment variable values must either be single quoted,
     *     double quoted, or function calls.}
     */
    public static Localizable _ModelParser_InvalidEnvironmentValue() {
        return new Localizable(holder, "ModelParser.InvalidEnvironmentValue");
    }

    /**
     * Key {@code ModelParser.NoArgForMapMethodKey}: {@code No argument for
     * map key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for map key "{0}"}
     */
    public static String ModelParser_NoArgForMapMethodKey(Object arg0) {
        return holder.format("ModelParser.NoArgForMapMethodKey", arg0);
    }

    /**
     * Key {@code ModelParser.NoArgForMapMethodKey}: {@code No argument for
     * map key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for map key "{0}"}
     */
    public static Localizable _ModelParser_NoArgForMapMethodKey(Object arg0) {
        return new Localizable(holder, "ModelParser.NoArgForMapMethodKey", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.ToolsInNestedStages}: {@code "tools" is
     * not allowed in stage "{0}" as it contains parallel stages}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "tools" is not allowed in stage "{0}" as it contains parallel
     *     stages}
     */
    public static String ModelValidatorImpl_ToolsInNestedStages(Object arg0) {
        return holder.format("ModelValidatorImpl.ToolsInNestedStages", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.ToolsInNestedStages}: {@code "tools" is
     * not allowed in stage "{0}" as it contains parallel stages}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "tools" is not allowed in stage "{0}" as it contains parallel
     *     stages}
     */
    public static Localizable _ModelValidatorImpl_ToolsInNestedStages(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.ToolsInNestedStages", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedBoolean}: {@code Expected a boolean
     * with {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a boolean with {0}}
     */
    public static String ModelParser_ExpectedBoolean(Object arg0) {
        return holder.format("ModelParser.ExpectedBoolean", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedBoolean}: {@code Expected a boolean
     * with {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a boolean with {0}}
     */
    public static Localizable _ModelParser_ExpectedBoolean(Object arg0) {
        return new Localizable(holder, "ModelParser.ExpectedBoolean", arg0);
    }

    /**
     * Key {@code ModelParser.NoArgForAgent}: {@code No argument for agent}.
     * 
     * @return
     *     {@code No argument for agent}
     */
    public static String ModelParser_NoArgForAgent() {
        return holder.format("ModelParser.NoArgForAgent");
    }

    /**
     * Key {@code ModelParser.NoArgForAgent}: {@code No argument for agent}.
     * 
     * @return
     *     {@code No argument for agent}
     */
    public static Localizable _ModelParser_NoArgForAgent() {
        return new Localizable(holder, "ModelParser.NoArgForAgent");
    }

    /**
     * Key {@code ModelValidatorImpl.BlockedStep}: {@code Invalid step "{0}"
     * used - not allowed in this context - {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid step "{0}" used - not allowed in this context - {1}}
     */
    public static String ModelValidatorImpl_BlockedStep(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.BlockedStep", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.BlockedStep}: {@code Invalid step "{0}"
     * used - not allowed in this context - {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid step "{0}" used - not allowed in this context - {1}}
     */
    public static Localizable _ModelValidatorImpl_BlockedStep(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.BlockedStep", arg0, arg1);
    }

    /**
     * Key {@code Parser.Libraries}: {@code Libraries}.
     * 
     * @return
     *     {@code Libraries}
     */
    public static String Parser_Libraries() {
        return holder.format("Parser.Libraries");
    }

    /**
     * Key {@code Parser.Libraries}: {@code Libraries}.
     * 
     * @return
     *     {@code Libraries}
     */
    public static Localizable _Parser_Libraries() {
        return new Localizable(holder, "Parser.Libraries");
    }

    /**
     * Key {@code ModelParser.InvalidStageSectionDefinition}: {@code Not a
     * valid stage section definition: "{0}". Some extra configuration is
     * required.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not a valid stage section definition: "{0}". Some extra
     *     configuration is required.}
     */
    public static String ModelParser_InvalidStageSectionDefinition(Object arg0) {
        return holder.format("ModelParser.InvalidStageSectionDefinition", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidStageSectionDefinition}: {@code Not a
     * valid stage section definition: "{0}". Some extra configuration is
     * required.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not a valid stage section definition: "{0}". Some extra
     *     configuration is required.}
     */
    public static Localizable _ModelParser_InvalidStageSectionDefinition(Object arg0) {
        return new Localizable(holder, "ModelParser.InvalidStageSectionDefinition", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidAgent}: {@code Invalid argument
     * for agent - "{0}" - must be map of config options or bare {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid argument for agent - "{0}" - must be map of config
     *     options or bare {1}.}
     */
    public static String ModelValidatorImpl_InvalidAgent(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.InvalidAgent", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidAgent}: {@code Invalid argument
     * for agent - "{0}" - must be map of config options or bare {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid argument for agent - "{0}" - must be map of config
     *     options or bare {1}.}
     */
    public static Localizable _ModelValidatorImpl_InvalidAgent(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidAgent", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidAgentParameter}: {@code Invalid
     * config option "{0}" for agent type "{1}". Valid config options are
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid config option "{0}" for agent type "{1}". Valid config
     *     options are {2}}
     */
    public static String ModelValidatorImpl_InvalidAgentParameter(Object arg0, Object arg1, Object arg2) {
        return holder.format("ModelValidatorImpl.InvalidAgentParameter", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidAgentParameter}: {@code Invalid
     * config option "{0}" for agent type "{1}". Valid config options are
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid config option "{0}" for agent type "{1}". Valid config
     *     options are {2}}
     */
    public static Localizable _ModelValidatorImpl_InvalidAgentParameter(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidAgentParameter", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateOptionName}: {@code Duplicate
     * option name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate option name: "{0}"}
     */
    public static String ModelValidatorImpl_DuplicateOptionName(Object arg0) {
        return holder.format("ModelValidatorImpl.DuplicateOptionName", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateOptionName}: {@code Duplicate
     * option name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate option name: "{0}"}
     */
    public static Localizable _ModelValidatorImpl_DuplicateOptionName(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.DuplicateOptionName", arg0);
    }

    /**
     * Key {@code ModelParser.PipelineBlockNotAtTop}: {@code {0} block must
     * be at the top-level, not within another block.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} block must be at the top-level, not within another block.}
     */
    public static String ModelParser_PipelineBlockNotAtTop(Object arg0) {
        return holder.format("ModelParser.PipelineBlockNotAtTop", arg0);
    }

    /**
     * Key {@code ModelParser.PipelineBlockNotAtTop}: {@code {0} block must
     * be at the top-level, not within another block.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} block must be at the top-level, not within another block.}
     */
    public static Localizable _ModelParser_PipelineBlockNotAtTop(Object arg0) {
        return new Localizable(holder, "ModelParser.PipelineBlockNotAtTop", arg0);
    }

    /**
     * Key {@code ModelParser.TooManyArgsForField}: {@code Too many arguments
     * for field "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for field "{0}"}
     */
    public static String ModelParser_TooManyArgsForField(Object arg0) {
        return holder.format("ModelParser.TooManyArgsForField", arg0);
    }

    /**
     * Key {@code ModelParser.TooManyArgsForField}: {@code Too many arguments
     * for field "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for field "{0}"}
     */
    public static Localizable _ModelParser_TooManyArgsForField(Object arg0) {
        return new Localizable(holder, "ModelParser.TooManyArgsForField", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedStringLiteralButGot}: {@code Expected
     * string literal but got {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected string literal but got {0}}
     */
    public static String ModelParser_ExpectedStringLiteralButGot(Object arg0) {
        return holder.format("ModelParser.ExpectedStringLiteralButGot", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedStringLiteralButGot}: {@code Expected
     * string literal but got {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected string literal but got {0}}
     */
    public static Localizable _ModelParser_ExpectedStringLiteralButGot(Object arg0) {
        return new Localizable(holder, "ModelParser.ExpectedStringLiteralButGot", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedLibrary}: {@code Expected a "lib(...)"
     * but got {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a "lib(...)" but got {0}}
     */
    public static String ModelParser_ExpectedLibrary(Object arg0) {
        return holder.format("ModelParser.ExpectedLibrary", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedLibrary}: {@code Expected a "lib(...)"
     * but got {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a "lib(...)" but got {0}}
     */
    public static Localizable _ModelParser_ExpectedLibrary(Object arg0) {
        return new Localizable(holder, "ModelParser.ExpectedLibrary", arg0);
    }

    /**
     * Key {@code ModelParser.RenamedNotifications}: {@code The
     * 'notifications' section has been removed as of version 0.6. Use 'post'
     * for all post-build actions.}.
     * 
     * @return
     *     {@code The 'notifications' section has been removed as of version 0.6.
     *     Use 'post' for all post-build actions.}
     */
    public static String ModelParser_RenamedNotifications() {
        return holder.format("ModelParser.RenamedNotifications");
    }

    /**
     * Key {@code ModelParser.RenamedNotifications}: {@code The
     * 'notifications' section has been removed as of version 0.6. Use 'post'
     * for all post-build actions.}.
     * 
     * @return
     *     {@code The 'notifications' section has been removed as of version 0.6.
     *     Use 'post' for all post-build actions.}
     */
    public static Localizable _ModelParser_RenamedNotifications() {
        return new Localizable(holder, "ModelParser.RenamedNotifications");
    }

    /**
     * Key {@code Parser.BuildParameters}: {@code Build parameters}.
     * 
     * @return
     *     {@code Build parameters}
     */
    public static String Parser_BuildParameters() {
        return holder.format("Parser.BuildParameters");
    }

    /**
     * Key {@code Parser.BuildParameters}: {@code Build parameters}.
     * 
     * @return
     *     {@code Build parameters}
     */
    public static Localizable _Parser_BuildParameters() {
        return new Localizable(holder, "Parser.BuildParameters");
    }

    /**
     * Key {@code ModelValidatorImpl.NotSingleRequiredParameter}: {@code Step
     * does not take a single required parameter - use named parameters
     * instead}.
     * 
     * @return
     *     {@code Step does not take a single required parameter - use named
     *     parameters instead}
     */
    public static String ModelValidatorImpl_NotSingleRequiredParameter() {
        return holder.format("ModelValidatorImpl.NotSingleRequiredParameter");
    }

    /**
     * Key {@code ModelValidatorImpl.NotSingleRequiredParameter}: {@code Step
     * does not take a single required parameter - use named parameters
     * instead}.
     * 
     * @return
     *     {@code Step does not take a single required parameter - use named
     *     parameters instead}
     */
    public static Localizable _ModelValidatorImpl_NotSingleRequiredParameter() {
        return new Localizable(holder, "ModelValidatorImpl.NotSingleRequiredParameter");
    }

    /**
     * Key {@code ModelInterpreter.NoNodeContext}: {@code Attempted to
     * execute a step that requires a node context while 'agent none' was
     * specified. Be sure to specify your own 'node { ... }' blocks when
     * using 'agent none'.}.
     * 
     * @return
     *     {@code Attempted to execute a step that requires a node context while
     *     'agent none' was specified. Be sure to specify your own 'node { ... }'
     *     blocks when using 'agent none'.}
     */
    public static String ModelInterpreter_NoNodeContext() {
        return holder.format("ModelInterpreter.NoNodeContext");
    }

    /**
     * Key {@code ModelInterpreter.NoNodeContext}: {@code Attempted to
     * execute a step that requires a node context while 'agent none' was
     * specified. Be sure to specify your own 'node { ... }' blocks when
     * using 'agent none'.}.
     * 
     * @return
     *     {@code Attempted to execute a step that requires a node context while
     *     'agent none' was specified. Be sure to specify your own 'node { ... }'
     *     blocks when using 'agent none'.}
     */
    public static Localizable _ModelInterpreter_NoNodeContext() {
        return new Localizable(holder, "ModelInterpreter.NoNodeContext");
    }

    /**
     * Key {@code ModelParser.NoArgForTool}: {@code No argument for tool
     * "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for tool "{0}"}
     */
    public static String ModelParser_NoArgForTool(Object arg0) {
        return holder.format("ModelParser.NoArgForTool", arg0);
    }

    /**
     * Key {@code ModelParser.NoArgForTool}: {@code No argument for tool
     * "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for tool "{0}"}
     */
    public static Localizable _ModelParser_NoArgForTool(Object arg0) {
        return new Localizable(holder, "ModelParser.NoArgForTool", arg0);
    }

    /**
     * Key {@code ModelParser.NoArgForAgentKey}: {@code No argument for agent
     * key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for agent key "{0}"}
     */
    public static String ModelParser_NoArgForAgentKey(Object arg0) {
        return holder.format("ModelParser.NoArgForAgentKey", arg0);
    }

    /**
     * Key {@code ModelParser.NoArgForAgentKey}: {@code No argument for agent
     * key "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for agent key "{0}"}
     */
    public static Localizable _ModelParser_NoArgForAgentKey(Object arg0) {
        return new Localizable(holder, "ModelParser.NoArgForAgentKey", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedBuildParameter}: {@code Expected a
     * build parameter definition}.
     * 
     * @return
     *     {@code Expected a build parameter definition}
     */
    public static String ModelParser_ExpectedBuildParameter() {
        return holder.format("ModelParser.ExpectedBuildParameter");
    }

    /**
     * Key {@code ModelParser.ExpectedBuildParameter}: {@code Expected a
     * build parameter definition}.
     * 
     * @return
     *     {@code Expected a build parameter definition}
     */
    public static Localizable _ModelParser_ExpectedBuildParameter() {
        return new Localizable(holder, "ModelParser.ExpectedBuildParameter");
    }

    /**
     * Key {@code ModelValidatorImpl.NoSteps}: {@code No steps specified for
     * branch}.
     * 
     * @return
     *     {@code No steps specified for branch}
     */
    public static String ModelValidatorImpl_NoSteps() {
        return holder.format("ModelValidatorImpl.NoSteps");
    }

    /**
     * Key {@code ModelValidatorImpl.NoSteps}: {@code No steps specified for
     * branch}.
     * 
     * @return
     *     {@code No steps specified for branch}
     */
    public static Localizable _ModelValidatorImpl_NoSteps() {
        return new Localizable(holder, "ModelValidatorImpl.NoSteps");
    }

    /**
     * Key {@code ModelParser.OneAgentMax}: {@code Only one agent type is
     * allowed per agent section}.
     * 
     * @return
     *     {@code Only one agent type is allowed per agent section}
     */
    public static String ModelParser_OneAgentMax() {
        return holder.format("ModelParser.OneAgentMax");
    }

    /**
     * Key {@code ModelParser.OneAgentMax}: {@code Only one agent type is
     * allowed per agent section}.
     * 
     * @return
     *     {@code Only one agent type is allowed per agent section}
     */
    public static Localizable _ModelParser_OneAgentMax() {
        return new Localizable(holder, "ModelParser.OneAgentMax");
    }

    /**
     * Key {@code ModelValidatorImpl.MissingRequiredStepParameter}: {@code
     * Missing required parameter: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing required parameter: "{0}"}
     */
    public static String ModelValidatorImpl_MissingRequiredStepParameter(Object arg0) {
        return holder.format("ModelValidatorImpl.MissingRequiredStepParameter", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.MissingRequiredStepParameter}: {@code
     * Missing required parameter: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing required parameter: "{0}"}
     */
    public static Localizable _ModelValidatorImpl_MissingRequiredStepParameter(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.MissingRequiredStepParameter", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoTools}: {@code No tools specified}.
     * 
     * @return
     *     {@code No tools specified}
     */
    public static String ModelValidatorImpl_NoTools() {
        return holder.format("ModelValidatorImpl.NoTools");
    }

    /**
     * Key {@code ModelValidatorImpl.NoTools}: {@code No tools specified}.
     * 
     * @return
     *     {@code No tools specified}
     */
    public static Localizable _ModelValidatorImpl_NoTools() {
        return new Localizable(holder, "ModelValidatorImpl.NoTools");
    }

    /**
     * Key {@code JSONParser.MethArgsMustBeObj}: {@code Individual method or
     * function arguments must be a JSON object}.
     * 
     * @return
     *     {@code Individual method or function arguments must be a JSON object}
     */
    public static String JSONParser_MethArgsMustBeObj() {
        return holder.format("JSONParser.MethArgsMustBeObj");
    }

    /**
     * Key {@code JSONParser.MethArgsMustBeObj}: {@code Individual method or
     * function arguments must be a JSON object}.
     * 
     * @return
     *     {@code Individual method or function arguments must be a JSON object}
     */
    public static Localizable _JSONParser_MethArgsMustBeObj() {
        return new Localizable(holder, "JSONParser.MethArgsMustBeObj");
    }

    /**
     * Key {@code JSONParser.MissingPipelineRoot}: {@code No pipeline block
     * or invalid pipeline block content}.
     * 
     * @return
     *     {@code No pipeline block or invalid pipeline block content}
     */
    public static String JSONParser_MissingPipelineRoot() {
        return holder.format("JSONParser.MissingPipelineRoot");
    }

    /**
     * Key {@code JSONParser.MissingPipelineRoot}: {@code No pipeline block
     * or invalid pipeline block content}.
     * 
     * @return
     *     {@code No pipeline block or invalid pipeline block content}
     */
    public static Localizable _JSONParser_MissingPipelineRoot() {
        return new Localizable(holder, "JSONParser.MissingPipelineRoot");
    }

    /**
     * Key {@code ModelParser.RenamedJobProperties}: {@code The
     * 'jobProperties' section has been renamed as of version 0.7. Use
     * 'properties' instead.}.
     * 
     * @return
     *     {@code The 'jobProperties' section has been renamed as of version 0.7.
     *     Use 'properties' instead.}
     */
    public static String ModelParser_RenamedJobProperties() {
        return holder.format("ModelParser.RenamedJobProperties");
    }

    /**
     * Key {@code ModelParser.RenamedJobProperties}: {@code The
     * 'jobProperties' section has been renamed as of version 0.7. Use
     * 'properties' instead.}.
     * 
     * @return
     *     {@code The 'jobProperties' section has been renamed as of version 0.7.
     *     Use 'properties' instead.}
     */
    public static Localizable _ModelParser_RenamedJobProperties() {
        return new Localizable(holder, "ModelParser.RenamedJobProperties");
    }

    /**
     * Key {@code ModelParser.InvalidAgent}: {@code Only "agent none", "agent
     * any" or "agent '{'...}" are allowed.}.
     * 
     * @return
     *     {@code Only "agent none", "agent any" or "agent '{'...}" are allowed.}
     */
    public static String ModelParser_InvalidAgent() {
        return holder.format("ModelParser.InvalidAgent");
    }

    /**
     * Key {@code ModelParser.InvalidAgent}: {@code Only "agent none", "agent
     * any" or "agent '{'...}" are allowed.}.
     * 
     * @return
     *     {@code Only "agent none", "agent any" or "agent '{'...}" are allowed.}
     */
    public static Localizable _ModelParser_InvalidAgent() {
        return new Localizable(holder, "ModelParser.InvalidAgent");
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidSectionType}: {@code Invalid {0}
     * type "{1}". Valid {0} types: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid {0} type "{1}". Valid {0} types: {2}}
     */
    public static String ModelValidatorImpl_InvalidSectionType(Object arg0, Object arg1, Object arg2) {
        return holder.format("ModelValidatorImpl.InvalidSectionType", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidSectionType}: {@code Invalid {0}
     * type "{1}". Valid {0} types: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid {0} type "{1}". Valid {0} types: {2}}
     */
    public static Localizable _ModelValidatorImpl_InvalidSectionType(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidSectionType", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidUnnamedParameterType}: {@code
     * Expecting "{0}" but got "{1}" of type {2} instead}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expecting "{0}" but got "{1}" of type {2} instead}
     */
    public static String ModelValidatorImpl_InvalidUnnamedParameterType(Object arg0, Object arg1, Object arg2) {
        return holder.format("ModelValidatorImpl.InvalidUnnamedParameterType", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidUnnamedParameterType}: {@code
     * Expecting "{0}" but got "{1}" of type {2} instead}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expecting "{0}" but got "{1}" of type {2} instead}
     */
    public static Localizable _ModelValidatorImpl_InvalidUnnamedParameterType(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidUnnamedParameterType", arg0, arg1, arg2);
    }

    /**
     * Key {@code JSONParser.MethCallMustBeObj}: {@code Method or function
     * call definition must be a JSON object}.
     * 
     * @return
     *     {@code Method or function call definition must be a JSON object}
     */
    public static String JSONParser_MethCallMustBeObj() {
        return holder.format("JSONParser.MethCallMustBeObj");
    }

    /**
     * Key {@code JSONParser.MethCallMustBeObj}: {@code Method or function
     * call definition must be a JSON object}.
     * 
     * @return
     *     {@code Method or function call definition must be a JSON object}
     */
    public static Localizable _JSONParser_MethCallMustBeObj() {
        return new Localizable(holder, "JSONParser.MethCallMustBeObj");
    }

    /**
     * Key {@code ModelParser.ExpectedWhen}: {@code Expected a when
     * condition}.
     * 
     * @return
     *     {@code Expected a when condition}
     */
    public static String ModelParser_ExpectedWhen() {
        return holder.format("ModelParser.ExpectedWhen");
    }

    /**
     * Key {@code ModelParser.ExpectedWhen}: {@code Expected a when
     * condition}.
     * 
     * @return
     *     {@code Expected a when condition}
     */
    public static Localizable _ModelParser_ExpectedWhen() {
        return new Localizable(holder, "ModelParser.ExpectedWhen");
    }

    /**
     * Key {@code ModelValidatorImpl.NoNestedWhenAllowed}: {@code No children
     * when conditions are allowed for when condition "{0}".}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No children when conditions are allowed for when condition
     *     "{0}".}
     */
    public static String ModelValidatorImpl_NoNestedWhenAllowed(Object arg0) {
        return holder.format("ModelValidatorImpl.NoNestedWhenAllowed", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoNestedWhenAllowed}: {@code No children
     * when conditions are allowed for when condition "{0}".}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No children when conditions are allowed for when condition
     *     "{0}".}
     */
    public static Localizable _ModelValidatorImpl_NoNestedWhenAllowed(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.NoNestedWhenAllowed", arg0);
    }

    /**
     * Key {@code JSONParser.InvalidArgumentSyntax}: {@code Invalid argument
     * syntax}.
     * 
     * @return
     *     {@code Invalid argument syntax}
     */
    public static String JSONParser_InvalidArgumentSyntax() {
        return holder.format("JSONParser.InvalidArgumentSyntax");
    }

    /**
     * Key {@code JSONParser.InvalidArgumentSyntax}: {@code Invalid argument
     * syntax}.
     * 
     * @return
     *     {@code Invalid argument syntax}
     */
    public static Localizable _JSONParser_InvalidArgumentSyntax() {
        return new Localizable(holder, "JSONParser.InvalidArgumentSyntax");
    }

    /**
     * Key {@code ModelParser.StepWithoutBlock}: {@code {0} step without a
     * block}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} step without a block}
     */
    public static String ModelParser_StepWithoutBlock(Object arg0) {
        return holder.format("ModelParser.StepWithoutBlock", arg0);
    }

    /**
     * Key {@code ModelParser.StepWithoutBlock}: {@code {0} step without a
     * block}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} step without a block}
     */
    public static Localizable _ModelParser_StepWithoutBlock(Object arg0) {
        return new Localizable(holder, "ModelParser.StepWithoutBlock", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateBuildCondition}: {@code
     * Duplicate build condition name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate build condition name: "{0}"}
     */
    public static String ModelValidatorImpl_DuplicateBuildCondition(Object arg0) {
        return holder.format("ModelValidatorImpl.DuplicateBuildCondition", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateBuildCondition}: {@code
     * Duplicate build condition name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate build condition name: "{0}"}
     */
    public static Localizable _ModelValidatorImpl_DuplicateBuildCondition(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.DuplicateBuildCondition", arg0);
    }

    /**
     * Key {@code JSONParser.InvalidGroovyString}: {@code {0} is not a valid
     * Groovy string value}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a valid Groovy string value}
     */
    public static String JSONParser_InvalidGroovyString(Object arg0) {
        return holder.format("JSONParser.InvalidGroovyString", arg0);
    }

    /**
     * Key {@code JSONParser.InvalidGroovyString}: {@code {0} is not a valid
     * Groovy string value}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a valid Groovy string value}
     */
    public static Localizable _JSONParser_InvalidGroovyString(Object arg0) {
        return new Localizable(holder, "JSONParser.InvalidGroovyString", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedClosureOrFailFast}: {@code Expected
     * closure or failFast}.
     * 
     * @return
     *     {@code Expected closure or failFast}
     */
    public static String ModelParser_ExpectedClosureOrFailFast() {
        return holder.format("ModelParser.ExpectedClosureOrFailFast");
    }

    /**
     * Key {@code ModelParser.ExpectedClosureOrFailFast}: {@code Expected
     * closure or failFast}.
     * 
     * @return
     *     {@code Expected closure or failFast}
     */
    public static Localizable _ModelParser_ExpectedClosureOrFailFast() {
        return new Localizable(holder, "ModelParser.ExpectedClosureOrFailFast");
    }

    /**
     * Key {@code ModelParser.PipelineStepWithoutBlock}: {@code Expected a
     * block with the "{0}" step}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a block with the "{0}" step}
     */
    public static String ModelParser_PipelineStepWithoutBlock(Object arg0) {
        return holder.format("ModelParser.PipelineStepWithoutBlock", arg0);
    }

    /**
     * Key {@code ModelParser.PipelineStepWithoutBlock}: {@code Expected a
     * block with the "{0}" step}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a block with the "{0}" step}
     */
    public static Localizable _ModelParser_PipelineStepWithoutBlock(Object arg0) {
        return new Localizable(holder, "ModelParser.PipelineStepWithoutBlock", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoAgentType}: {@code No agent type
     * specified. Must be one of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No agent type specified. Must be one of {0}}
     */
    public static String ModelValidatorImpl_NoAgentType(Object arg0) {
        return holder.format("ModelValidatorImpl.NoAgentType", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoAgentType}: {@code No agent type
     * specified. Must be one of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No agent type specified. Must be one of {0}}
     */
    public static Localizable _ModelValidatorImpl_NoAgentType(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.NoAgentType", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoStageName}: {@code Stage does not have
     * a name}.
     * 
     * @return
     *     {@code Stage does not have a name}
     */
    public static String ModelValidatorImpl_NoStageName() {
        return holder.format("ModelValidatorImpl.NoStageName");
    }

    /**
     * Key {@code ModelValidatorImpl.NoStageName}: {@code Stage does not have
     * a name}.
     * 
     * @return
     *     {@code Stage does not have a name}
     */
    public static Localizable _ModelValidatorImpl_NoStageName() {
        return new Localizable(holder, "ModelValidatorImpl.NoStageName");
    }

    /**
     * Key {@code ModelValidatorImpl.MissingInputMessage}: {@code No message
     * specified for input}.
     * 
     * @return
     *     {@code No message specified for input}
     */
    public static String ModelValidatorImpl_MissingInputMessage() {
        return holder.format("ModelValidatorImpl.MissingInputMessage");
    }

    /**
     * Key {@code ModelValidatorImpl.MissingInputMessage}: {@code No message
     * specified for input}.
     * 
     * @return
     *     {@code No message specified for input}
     */
    public static Localizable _ModelValidatorImpl_MissingInputMessage() {
        return new Localizable(holder, "ModelValidatorImpl.MissingInputMessage");
    }

    /**
     * Key {@code ModelValidatorImpl.WrongNumberOfStepParameters}: {@code
     * "{0}" should have {1} arguments but has {2} arguments instead.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" should have {1} arguments but has {2} arguments instead.}
     */
    public static String ModelValidatorImpl_WrongNumberOfStepParameters(Object arg0, Object arg1, Object arg2) {
        return holder.format("ModelValidatorImpl.WrongNumberOfStepParameters", arg0, arg1, arg2);
    }

    /**
     * Key {@code ModelValidatorImpl.WrongNumberOfStepParameters}: {@code
     * "{0}" should have {1} arguments but has {2} arguments instead.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" should have {1} arguments but has {2} arguments instead.}
     */
    public static Localizable _ModelValidatorImpl_WrongNumberOfStepParameters(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ModelValidatorImpl.WrongNumberOfStepParameters", arg0, arg1, arg2);
    }

    /**
     * Key {@code Parser.UndefinedSection}: {@code Undefined section "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Undefined section "{0}"}
     */
    public static String Parser_UndefinedSection(Object arg0) {
        return holder.format("Parser.UndefinedSection", arg0);
    }

    /**
     * Key {@code Parser.UndefinedSection}: {@code Undefined section "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Undefined section "{0}"}
     */
    public static Localizable _Parser_UndefinedSection(Object arg0) {
        return new Localizable(holder, "Parser.UndefinedSection", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedTool}: {@code Expected to find
     * 'someTool "someVersion"'}.
     * 
     * @return
     *     {@code Expected to find 'someTool "someVersion"'}
     */
    public static String ModelParser_ExpectedTool() {
        return holder.format("ModelParser.ExpectedTool");
    }

    /**
     * Key {@code ModelParser.ExpectedTool}: {@code Expected to find
     * 'someTool "someVersion"'}.
     * 
     * @return
     *     {@code Expected to find 'someTool "someVersion"'}
     */
    public static Localizable _ModelParser_ExpectedTool() {
        return new Localizable(holder, "ModelParser.ExpectedTool");
    }

    /**
     * Key {@code ModelParser.RenamedPostBuild}: {@code The 'postBuild'
     * section has been renamed as of version 0.6. Use 'post' for all
     * post-build actions.}.
     * 
     * @return
     *     {@code The 'postBuild' section has been renamed as of version 0.6. Use
     *     'post' for all post-build actions.}
     */
    public static String ModelParser_RenamedPostBuild() {
        return holder.format("ModelParser.RenamedPostBuild");
    }

    /**
     * Key {@code ModelParser.RenamedPostBuild}: {@code The 'postBuild'
     * section has been renamed as of version 0.6. Use 'post' for all
     * post-build actions.}.
     * 
     * @return
     *     {@code The 'postBuild' section has been renamed as of version 0.6. Use
     *     'post' for all post-build actions.}
     */
    public static Localizable _ModelParser_RenamedPostBuild() {
        return new Localizable(holder, "ModelParser.RenamedPostBuild");
    }

    /**
     * Key {@code ModelValidatorImpl.CompilationErrorInCodeBlock}: {@code
     * Groovy compilation error(s) in {0}. Error(s): "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Groovy compilation error(s) in {0}. Error(s): "{1}"}
     */
    public static String ModelValidatorImpl_CompilationErrorInCodeBlock(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.CompilationErrorInCodeBlock", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.CompilationErrorInCodeBlock}: {@code
     * Groovy compilation error(s) in {0}. Error(s): "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Groovy compilation error(s) in {0}. Error(s): "{1}"}
     */
    public static Localizable _ModelValidatorImpl_CompilationErrorInCodeBlock(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.CompilationErrorInCodeBlock", arg0, arg1);
    }

    /**
     * Key {@code ModelParser.StageWithoutBlock}: {@code Stage doesn't have a
     * block}.
     * 
     * @return
     *     {@code Stage doesn't have a block}
     */
    public static String ModelParser_StageWithoutBlock() {
        return holder.format("ModelParser.StageWithoutBlock");
    }

    /**
     * Key {@code ModelParser.StageWithoutBlock}: {@code Stage doesn't have a
     * block}.
     * 
     * @return
     *     {@code Stage doesn't have a block}
     */
    public static Localizable _ModelParser_StageWithoutBlock() {
        return new Localizable(holder, "ModelParser.StageWithoutBlock");
    }

    /**
     * Key {@code ModelParser.MapNotAllowed}: {@code {0} cannot be defined as
     * maps}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} cannot be defined as maps}
     */
    public static String ModelParser_MapNotAllowed(Object arg0) {
        return holder.format("ModelParser.MapNotAllowed", arg0);
    }

    /**
     * Key {@code ModelParser.MapNotAllowed}: {@code {0} cannot be defined as
     * maps}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} cannot be defined as maps}
     */
    public static Localizable _ModelParser_MapNotAllowed(Object arg0) {
        return new Localizable(holder, "ModelParser.MapNotAllowed", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.EmptySection}: {@code {0} can not be
     * empty}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} can not be empty}
     */
    public static String ModelValidatorImpl_EmptySection(Object arg0) {
        return holder.format("ModelValidatorImpl.EmptySection", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.EmptySection}: {@code {0} can not be
     * empty}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} can not be empty}
     */
    public static Localizable _ModelValidatorImpl_EmptySection(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.EmptySection", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedAgent}: {@code Expected an agent}.
     * 
     * @return
     *     {@code Expected an agent}
     */
    public static String ModelParser_ExpectedAgent() {
        return holder.format("ModelParser.ExpectedAgent");
    }

    /**
     * Key {@code ModelParser.ExpectedAgent}: {@code Expected an agent}.
     * 
     * @return
     *     {@code Expected an agent}
     */
    public static Localizable _ModelParser_ExpectedAgent() {
        return new Localizable(holder, "ModelParser.ExpectedAgent");
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidAgentType}: {@code Invalid agent
     * type "{0}" specified. Must be one of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid agent type "{0}" specified. Must be one of {1}}
     */
    public static String ModelValidatorImpl_InvalidAgentType(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.InvalidAgentType", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.InvalidAgentType}: {@code Invalid agent
     * type "{0}" specified. Must be one of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid agent type "{0}" specified. Must be one of {1}}
     */
    public static Localizable _ModelValidatorImpl_InvalidAgentType(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.InvalidAgentType", arg0, arg1);
    }

    /**
     * Key {@code ModelParser.MethodCallWithClosure}: {@code Method call
     * arguments}.
     * 
     * @return
     *     {@code Method call arguments}
     */
    public static String ModelParser_MethodCallWithClosure() {
        return holder.format("ModelParser.MethodCallWithClosure");
    }

    /**
     * Key {@code ModelParser.MethodCallWithClosure}: {@code Method call
     * arguments}.
     * 
     * @return
     *     {@code Method call arguments}
     */
    public static Localizable _ModelParser_MethodCallWithClosure() {
        return new Localizable(holder, "ModelParser.MethodCallWithClosure");
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateParallelName}: {@code Duplicate
     * parallel branch name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate parallel branch name: "{0}"}
     */
    public static String ModelValidatorImpl_DuplicateParallelName(Object arg0) {
        return holder.format("ModelValidatorImpl.DuplicateParallelName", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.DuplicateParallelName}: {@code Duplicate
     * parallel branch name: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate parallel branch name: "{0}"}
     */
    public static Localizable _ModelValidatorImpl_DuplicateParallelName(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.DuplicateParallelName", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedStageName}: {@code Expected a stage
     * name but didn't find any}.
     * 
     * @return
     *     {@code Expected a stage name but didn't find any}
     */
    public static String ModelParser_ExpectedStageName() {
        return holder.format("ModelParser.ExpectedStageName");
    }

    /**
     * Key {@code ModelParser.ExpectedStageName}: {@code Expected a stage
     * name but didn't find any}.
     * 
     * @return
     *     {@code Expected a stage name but didn't find any}
     */
    public static Localizable _ModelParser_ExpectedStageName() {
        return new Localizable(holder, "ModelParser.ExpectedStageName");
    }

    /**
     * Key {@code JSONParser.MethArgsMissing}: {@code Method or function
     * arguments missing or not an array}.
     * 
     * @return
     *     {@code Method or function arguments missing or not an array}
     */
    public static String JSONParser_MethArgsMissing() {
        return holder.format("JSONParser.MethArgsMissing");
    }

    /**
     * Key {@code JSONParser.MethArgsMissing}: {@code Method or function
     * arguments missing or not an array}.
     * 
     * @return
     *     {@code Method or function arguments missing or not an array}
     */
    public static Localizable _JSONParser_MethArgsMissing() {
        return new Localizable(holder, "JSONParser.MethArgsMissing");
    }

    /**
     * Key {@code ModelValidatorImpl.MixedNamedAndUnnamedParameters}: {@code
     * Can't mix named and unnamed arguments}.
     * 
     * @return
     *     {@code Can't mix named and unnamed arguments}
     */
    public static String ModelValidatorImpl_MixedNamedAndUnnamedParameters() {
        return holder.format("ModelValidatorImpl.MixedNamedAndUnnamedParameters");
    }

    /**
     * Key {@code ModelValidatorImpl.MixedNamedAndUnnamedParameters}: {@code
     * Can't mix named and unnamed arguments}.
     * 
     * @return
     *     {@code Can't mix named and unnamed arguments}
     */
    public static Localizable _ModelValidatorImpl_MixedNamedAndUnnamedParameters() {
        return new Localizable(holder, "ModelValidatorImpl.MixedNamedAndUnnamedParameters");
    }

    /**
     * Key {@code WhenConditionalValidator.changelog.missingParameter}:
     * {@code Changelog is missing required parameter "pattern".}.
     * 
     * @return
     *     {@code Changelog is missing required parameter "pattern".}
     */
    public static String WhenConditionalValidator_changelog_missingParameter() {
        return holder.format("WhenConditionalValidator.changelog.missingParameter");
    }

    /**
     * Key {@code WhenConditionalValidator.changelog.missingParameter}:
     * {@code Changelog is missing required parameter "pattern".}.
     * 
     * @return
     *     {@code Changelog is missing required parameter "pattern".}
     */
    public static Localizable _WhenConditionalValidator_changelog_missingParameter() {
        return new Localizable(holder, "WhenConditionalValidator.changelog.missingParameter");
    }

    /**
     * Key {@code ModelParser.InvalidInputField}: {@code Not a valid field
     * for input: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not a valid field for input: "{0}"}
     */
    public static String ModelParser_InvalidInputField(Object arg0) {
        return holder.format("ModelParser.InvalidInputField", arg0);
    }

    /**
     * Key {@code ModelParser.InvalidInputField}: {@code Not a valid field
     * for input: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not a valid field for input: "{0}"}
     */
    public static Localizable _ModelParser_InvalidInputField(Object arg0) {
        return new Localizable(holder, "ModelParser.InvalidInputField", arg0);
    }

    /**
     * Key {@code Parser.MultipleOfSection}: {@code Multiple occurrences of
     * the {0} section}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Multiple occurrences of the {0} section}
     */
    public static String Parser_MultipleOfSection(Object arg0) {
        return holder.format("Parser.MultipleOfSection", arg0);
    }

    /**
     * Key {@code Parser.MultipleOfSection}: {@code Multiple occurrences of
     * the {0} section}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Multiple occurrences of the {0} section}
     */
    public static Localizable _Parser_MultipleOfSection(Object arg0) {
        return new Localizable(holder, "Parser.MultipleOfSection", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedSymbol}: {@code Expected a symbol}.
     * 
     * @return
     *     {@code Expected a symbol}
     */
    public static String ModelParser_ExpectedSymbol() {
        return holder.format("ModelParser.ExpectedSymbol");
    }

    /**
     * Key {@code ModelParser.ExpectedSymbol}: {@code Expected a symbol}.
     * 
     * @return
     *     {@code Expected a symbol}
     */
    public static Localizable _ModelParser_ExpectedSymbol() {
        return new Localizable(holder, "ModelParser.ExpectedSymbol");
    }

    /**
     * Key {@code ModelParser.ExpectedBlockFor}: {@code Expected a block for
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a block for {0}}
     */
    public static String ModelParser_ExpectedBlockFor(Object arg0) {
        return holder.format("ModelParser.ExpectedBlockFor", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedBlockFor}: {@code Expected a block for
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected a block for {0}}
     */
    public static Localizable _ModelParser_ExpectedBlockFor(Object arg0) {
        return new Localizable(holder, "ModelParser.ExpectedBlockFor", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.AgentInNestedStages}: {@code "agent" is
     * not allowed in stage "{0}" as it contains parallel stages}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "agent" is not allowed in stage "{0}" as it contains parallel
     *     stages}
     */
    public static String ModelValidatorImpl_AgentInNestedStages(Object arg0) {
        return holder.format("ModelValidatorImpl.AgentInNestedStages", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.AgentInNestedStages}: {@code "agent" is
     * not allowed in stage "{0}" as it contains parallel stages}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "agent" is not allowed in stage "{0}" as it contains parallel
     *     stages}
     */
    public static Localizable _ModelValidatorImpl_AgentInNestedStages(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.AgentInNestedStages", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoEnvVars}: {@code No variables
     * specified for environment}.
     * 
     * @return
     *     {@code No variables specified for environment}
     */
    public static String ModelValidatorImpl_NoEnvVars() {
        return holder.format("ModelValidatorImpl.NoEnvVars");
    }

    /**
     * Key {@code ModelValidatorImpl.NoEnvVars}: {@code No variables
     * specified for environment}.
     * 
     * @return
     *     {@code No variables specified for environment}
     */
    public static Localizable _ModelValidatorImpl_NoEnvVars() {
        return new Localizable(holder, "ModelValidatorImpl.NoEnvVars");
    }

    /**
     * Key {@code ModelParser.TooManyArgsForTool}: {@code Too many arguments
     * for tool "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for tool "{0}"}
     */
    public static String ModelParser_TooManyArgsForTool(Object arg0) {
        return holder.format("ModelParser.TooManyArgsForTool", arg0);
    }

    /**
     * Key {@code ModelParser.TooManyArgsForTool}: {@code Too many arguments
     * for tool "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Too many arguments for tool "{0}"}
     */
    public static Localizable _ModelParser_TooManyArgsForTool(Object arg0) {
        return new Localizable(holder, "ModelParser.TooManyArgsForTool", arg0);
    }

    /**
     * Key {@code ModelParser.ExpectedTrigger}: {@code Expected a trigger}.
     * 
     * @return
     *     {@code Expected a trigger}
     */
    public static String ModelParser_ExpectedTrigger() {
        return holder.format("ModelParser.ExpectedTrigger");
    }

    /**
     * Key {@code ModelParser.ExpectedTrigger}: {@code Expected a trigger}.
     * 
     * @return
     *     {@code Expected a trigger}
     */
    public static Localizable _ModelParser_ExpectedTrigger() {
        return new Localizable(holder, "ModelParser.ExpectedTrigger");
    }

    /**
     * Key {@code ModelParser.ExpectedMapMethod}: {@code Expected to find
     * 'someKey "someValue"'}.
     * 
     * @return
     *     {@code Expected to find 'someKey "someValue"'}
     */
    public static String ModelParser_ExpectedMapMethod() {
        return holder.format("ModelParser.ExpectedMapMethod");
    }

    /**
     * Key {@code ModelParser.ExpectedMapMethod}: {@code Expected to find
     * 'someKey "someValue"'}.
     * 
     * @return
     *     {@code Expected to find 'someKey "someValue"'}
     */
    public static Localizable _ModelParser_ExpectedMapMethod() {
        return new Localizable(holder, "ModelParser.ExpectedMapMethod");
    }

    /**
     * Key {@code WhenConditionalValidator.changelog.badPattern}: {@code
     * "{0}" is not a valid regular expression. {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is not a valid regular expression. {1}}
     */
    public static String WhenConditionalValidator_changelog_badPattern(Object arg0, Object arg1) {
        return holder.format("WhenConditionalValidator.changelog.badPattern", arg0, arg1);
    }

    /**
     * Key {@code WhenConditionalValidator.changelog.badPattern}: {@code
     * "{0}" is not a valid regular expression. {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is not a valid regular expression. {1}}
     */
    public static Localizable _WhenConditionalValidator_changelog_badPattern(Object arg0, Object arg1) {
        return new Localizable(holder, "WhenConditionalValidator.changelog.badPattern", arg0, arg1);
    }

    /**
     * Key {@code PipelineModelDefinition.DisplayName}: {@code Pipeline Model
     * Definition}.
     * 
     * @return
     *     {@code Pipeline Model Definition}
     */
    public static String PipelineModelDefinition_DisplayName() {
        return holder.format("PipelineModelDefinition.DisplayName");
    }

    /**
     * Key {@code PipelineModelDefinition.DisplayName}: {@code Pipeline Model
     * Definition}.
     * 
     * @return
     *     {@code Pipeline Model Definition}
     */
    public static Localizable _PipelineModelDefinition_DisplayName() {
        return new Localizable(holder, "PipelineModelDefinition.DisplayName");
    }

    /**
     * Key {@code ModelValidatorImpl.MultipleAgentParameters}: {@code
     * Multiple parameters are required for agent type "{0}" - {1}. Please
     * use a block instead.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Multiple parameters are required for agent type "{0}" - {1}.
     *     Please use a block instead.}
     */
    public static String ModelValidatorImpl_MultipleAgentParameters(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.MultipleAgentParameters", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.MultipleAgentParameters}: {@code
     * Multiple parameters are required for agent type "{0}" - {1}. Please
     * use a block instead.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Multiple parameters are required for agent type "{0}" - {1}.
     *     Please use a block instead.}
     */
    public static Localizable _ModelValidatorImpl_MultipleAgentParameters(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.MultipleAgentParameters", arg0, arg1);
    }

    /**
     * Key {@code ModelParser.NoArgForField}: {@code No argument for field
     * "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for field "{0}"}
     */
    public static String ModelParser_NoArgForField(Object arg0) {
        return holder.format("ModelParser.NoArgForField", arg0);
    }

    /**
     * Key {@code ModelParser.NoArgForField}: {@code No argument for field
     * "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No argument for field "{0}"}
     */
    public static Localizable _ModelParser_NoArgForField(Object arg0) {
        return new Localizable(holder, "ModelParser.NoArgForField", arg0);
    }

    /**
     * Key {@code ModelParser.RenamedProperties}: {@code The 'properties'
     * section has been renamed as of version 0.8. Use 'options' instead.}.
     * 
     * @return
     *     {@code The 'properties' section has been renamed as of version 0.8.
     *     Use 'options' instead.}
     */
    public static String ModelParser_RenamedProperties() {
        return holder.format("ModelParser.RenamedProperties");
    }

    /**
     * Key {@code ModelParser.RenamedProperties}: {@code The 'properties'
     * section has been renamed as of version 0.8. Use 'options' instead.}.
     * 
     * @return
     *     {@code The 'properties' section has been renamed as of version 0.8.
     *     Use 'options' instead.}
     */
    public static Localizable _ModelParser_RenamedProperties() {
        return new Localizable(holder, "ModelParser.RenamedProperties");
    }

    /**
     * Key {@code ModelParser.ExpectedOption}: {@code Expected an option}.
     * 
     * @return
     *     {@code Expected an option}
     */
    public static String ModelParser_ExpectedOption() {
        return holder.format("ModelParser.ExpectedOption");
    }

    /**
     * Key {@code ModelParser.ExpectedOption}: {@code Expected an option}.
     * 
     * @return
     *     {@code Expected an option}
     */
    public static Localizable _ModelParser_ExpectedOption() {
        return new Localizable(holder, "ModelParser.ExpectedOption");
    }

    /**
     * Key {@code ModelValidatorImpl.MissingAgentParameter}: {@code Missing
     * required parameter for agent type "{0}": {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing required parameter for agent type "{0}": {1}}
     */
    public static String ModelValidatorImpl_MissingAgentParameter(Object arg0, Object arg1) {
        return holder.format("ModelValidatorImpl.MissingAgentParameter", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.MissingAgentParameter}: {@code Missing
     * required parameter for agent type "{0}": {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing required parameter for agent type "{0}": {1}}
     */
    public static Localizable _ModelValidatorImpl_MissingAgentParameter(Object arg0, Object arg1) {
        return new Localizable(holder, "ModelValidatorImpl.MissingAgentParameter", arg0, arg1);
    }

    /**
     * Key {@code ModelValidatorImpl.BothStagesAndSteps}: {@code Only one of
     * "parallel" or "steps" allowed for stage "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Only one of "parallel" or "steps" allowed for stage "{0}"}
     */
    public static String ModelValidatorImpl_BothStagesAndSteps(Object arg0) {
        return holder.format("ModelValidatorImpl.BothStagesAndSteps", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.BothStagesAndSteps}: {@code Only one of
     * "parallel" or "steps" allowed for stage "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Only one of "parallel" or "steps" allowed for stage "{0}"}
     */
    public static Localizable _ModelValidatorImpl_BothStagesAndSteps(Object arg0) {
        return new Localizable(holder, "ModelValidatorImpl.BothStagesAndSteps", arg0);
    }

    /**
     * Key {@code ModelValidatorImpl.NoStages}: {@code No stages specified}.
     * 
     * @return
     *     {@code No stages specified}
     */
    public static String ModelValidatorImpl_NoStages() {
        return holder.format("ModelValidatorImpl.NoStages");
    }

    /**
     * Key {@code ModelValidatorImpl.NoStages}: {@code No stages specified}.
     * 
     * @return
     *     {@code No stages specified}
     */
    public static Localizable _ModelValidatorImpl_NoStages() {
        return new Localizable(holder, "ModelValidatorImpl.NoStages");
    }

    /**
     * Key {@code ModelParser.ExpectedNVPairs}: {@code Expected name=value
     * pairs}.
     * 
     * @return
     *     {@code Expected name=value pairs}
     */
    public static String ModelParser_ExpectedNVPairs() {
        return holder.format("ModelParser.ExpectedNVPairs");
    }

    /**
     * Key {@code ModelParser.ExpectedNVPairs}: {@code Expected name=value
     * pairs}.
     * 
     * @return
     *     {@code Expected name=value pairs}
     */
    public static Localizable _ModelParser_ExpectedNVPairs() {
        return new Localizable(holder, "ModelParser.ExpectedNVPairs");
    }

    /**
     * Key {@code ModelParser.ExpectedStringLiteral}: {@code Expected string
     * literal}.
     * 
     * @return
     *     {@code Expected string literal}
     */
    public static String ModelParser_ExpectedStringLiteral() {
        return holder.format("ModelParser.ExpectedStringLiteral");
    }

    /**
     * Key {@code ModelParser.ExpectedStringLiteral}: {@code Expected string
     * literal}.
     * 
     * @return
     *     {@code Expected string literal}
     */
    public static Localizable _ModelParser_ExpectedStringLiteral() {
        return new Localizable(holder, "ModelParser.ExpectedStringLiteral");
    }

    /**
     * Key {@code DeclarativeLinterCommand.ShortDescription}: {@code Validate
     * a Jenkinsfile containing a Declarative Pipeline}.
     * 
     * @return
     *     {@code Validate a Jenkinsfile containing a Declarative Pipeline}
     */
    public static String DeclarativeLinterCommand_ShortDescription() {
        return holder.format("DeclarativeLinterCommand.ShortDescription");
    }

    /**
     * Key {@code DeclarativeLinterCommand.ShortDescription}: {@code Validate
     * a Jenkinsfile containing a Declarative Pipeline}.
     * 
     * @return
     *     {@code Validate a Jenkinsfile containing a Declarative Pipeline}
     */
    public static Localizable _DeclarativeLinterCommand_ShortDescription() {
        return new Localizable(holder, "DeclarativeLinterCommand.ShortDescription");
    }

    /**
     * Key {@code ModelParser.ExpectedStage}: {@code Expected a stage}.
     * 
     * @return
     *     {@code Expected a stage}
     */
    public static String ModelParser_ExpectedStage() {
        return holder.format("ModelParser.ExpectedStage");
    }

    /**
     * Key {@code ModelParser.ExpectedStage}: {@code Expected a stage}.
     * 
     * @return
     *     {@code Expected a stage}
     */
    public static Localizable _ModelParser_ExpectedStage() {
        return new Localizable(holder, "ModelParser.ExpectedStage");
    }

    /**
     * Key {@code JSONParser.MissingRequiredProperties}: {@code Missing one
     * or more required properties: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing one or more required properties: {0}}
     */
    public static String JSONParser_MissingRequiredProperties(Object arg0) {
        return holder.format("JSONParser.MissingRequiredProperties", arg0);
    }

    /**
     * Key {@code JSONParser.MissingRequiredProperties}: {@code Missing one
     * or more required properties: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Missing one or more required properties: {0}}
     */
    public static Localizable _JSONParser_MissingRequiredProperties(Object arg0) {
        return new Localizable(holder, "JSONParser.MissingRequiredProperties", arg0);
    }

}
