/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.agent;

import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.config.DockerPropertiesProvider;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public class DeclarativeDockerUtils {
    private static Run<?, ?> currentRun() {
        try {
            FlowExecutionOwner o;
            CpsFlowExecution e;
            CpsThread t = CpsThread.current();
            if (t != null && (e = t.getExecution()) != null && (o = e.getOwner()) != null && o.getExecutable() instanceof Run) {
                return (Run)o.getExecutable();
            }
            return null;
        }
        catch (IOException i) {
            return null;
        }
    }

    @Whitelisted
    public static String getLabel() {
        return DeclarativeDockerUtils.getLabel(null);
    }

    @Whitelisted
    public static String getLabel(@Nullable String override) {
        if (!StringUtils.isBlank((String)override)) {
            return override;
        }
        Run<?, ?> r = DeclarativeDockerUtils.currentRun();
        for (DockerPropertiesProvider provider : DockerPropertiesProvider.all()) {
            String label = provider.getLabel(r);
            if (StringUtils.isBlank((String)label)) continue;
            return label;
        }
        return null;
    }

    @Whitelisted
    public static String getRegistryUrl() {
        return DeclarativeDockerUtils.getRegistryUrl(null);
    }

    @Whitelisted
    public static String getRegistryUrl(@Nullable String override) {
        if (!StringUtils.isBlank((String)override)) {
            return override;
        }
        Run<?, ?> r = DeclarativeDockerUtils.currentRun();
        for (DockerPropertiesProvider provider : DockerPropertiesProvider.all()) {
            String url = provider.getRegistryUrl(r);
            if (StringUtils.isBlank((String)url)) continue;
            return url;
        }
        return null;
    }

    @Whitelisted
    public static String getRegistryCredentialsId() {
        return DeclarativeDockerUtils.getRegistryCredentialsId(null);
    }

    @Whitelisted
    public static String getRegistryCredentialsId(@Nullable String override) {
        if (!StringUtils.isBlank((String)override)) {
            return override;
        }
        Run<?, ?> r = DeclarativeDockerUtils.currentRun();
        for (DockerPropertiesProvider provider : DockerPropertiesProvider.all()) {
            String id = provider.getRegistryCredentialsId(r);
            if (StringUtils.isBlank((String)id)) continue;
            return id;
        }
        return null;
    }
}

