/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.model;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Run;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;
import org.jenkinsci.plugins.credentialsbinding.impl.FileBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.StringBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.UsernamePasswordBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.UsernamePasswordMultiBinding;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public abstract class CredentialsBindingHandler<C extends StandardCredentials>
implements ExtensionPoint {
    public boolean handles(Class<? extends StandardCredentials> c) {
        return this.type().isAssignableFrom(c);
    }

    public boolean handles(StandardCredentials c) {
        return this.handles(c.getClass());
    }

    @Nonnull
    public List<MultiBinding<C>> toBindings(String varName, String credentialsId) {
        return Collections.emptyList();
    }

    @Nonnull
    public abstract Class<? extends StandardCredentials> type();

    @Nonnull
    public abstract List<Map<String, Object>> getWithCredentialsParameters(String var1);

    @Nonnull
    public static ExtensionList<CredentialsBindingHandler> all() {
        return ExtensionList.lookup(CredentialsBindingHandler.class);
    }

    @Nonnull
    public static Set<Class<? extends StandardCredentials>> supportedTypes() {
        HashSet<Class<? extends StandardCredentials>> set = new HashSet<Class<? extends StandardCredentials>>();
        for (CredentialsBindingHandler handler : CredentialsBindingHandler.all()) {
            set.add(handler.type());
        }
        return set;
    }

    @Nonnull
    public static Set<String> supportedTypeNames() {
        HashSet<String> set = new HashSet<String>();
        for (Class<StandardCredentials> c : CredentialsBindingHandler.supportedTypes()) {
            set.add(c.getSimpleName());
        }
        return set;
    }

    @CheckForNull
    public static CredentialsBindingHandler forCredential(StandardCredentials c) {
        for (CredentialsBindingHandler handler : CredentialsBindingHandler.all()) {
            if (!handler.handles(c)) continue;
            return handler;
        }
        return null;
    }

    @Nonnull
    public static CredentialsBindingHandler forId(String id, Run context) throws CredentialNotFoundException {
        IdCredentials cred = CredentialsProvider.findCredentialById((String)id, IdCredentials.class, (Run)context, (DomainRequirement[])new DomainRequirement[0]);
        if (cred == null) {
            throw new CredentialNotFoundException(id);
        }
        if (cred instanceof StandardCredentials) {
            CredentialsBindingHandler handler = CredentialsBindingHandler.forCredential((StandardCredentials)cred);
            if (handler == null) {
                throw new CredentialNotFoundException(String.format("No suitable binding handler could be found for type %s. Supported types are %s.", cred.getClass().getName(), StringUtils.join(CredentialsBindingHandler.supportedTypeNames(), (char)',')));
            }
            return handler;
        }
        throw new CredentialNotFoundException(String.format("Credentials %s is of type %s where StandardCredentials is the expected type.", id, cred.getClass().getName()));
    }

    @Extension
    public static class StringCredentialsHandler
    extends CredentialsBindingHandler<StringCredentials> {
        @Override
        @Nonnull
        public List<MultiBinding<StringCredentials>> toBindings(String varName, String credentialsId) {
            return Collections.singletonList(new StringBinding(varName, credentialsId));
        }

        @Override
        @Nonnull
        public Class<? extends StandardCredentials> type() {
            return StringCredentials.class;
        }

        @Override
        @Nonnull
        public List<Map<String, Object>> getWithCredentialsParameters(String credentialsId) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("$class", StringBinding.class.getName());
            map.put("variable", new EnvVarResolver());
            map.put("credentialsId", credentialsId);
            return Collections.singletonList(map);
        }
    }

    @Extension
    public static class FileCredentialsHandler
    extends CredentialsBindingHandler<FileCredentials> {
        @Override
        @Nonnull
        public List<MultiBinding<FileCredentials>> toBindings(String varName, String credentialsId) {
            return Collections.singletonList(new FileBinding(varName, credentialsId));
        }

        @Override
        @Nonnull
        public Class<? extends StandardCredentials> type() {
            return FileCredentials.class;
        }

        @Override
        @Nonnull
        public List<Map<String, Object>> getWithCredentialsParameters(String credentialsId) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("$class", FileBinding.class.getName());
            map.put("variable", new EnvVarResolver());
            map.put("credentialsId", credentialsId);
            return Collections.singletonList(map);
        }
    }

    @Extension
    public static class UsernamePasswordHandler
    extends CredentialsBindingHandler<StandardUsernamePasswordCredentials> {
        @Override
        @Nonnull
        public List<MultiBinding<StandardUsernamePasswordCredentials>> toBindings(String varName, String credentialsId) {
            ArrayList<MultiBinding<StandardUsernamePasswordCredentials>> bindings = new ArrayList<MultiBinding<StandardUsernamePasswordCredentials>>();
            bindings.add((MultiBinding<StandardUsernamePasswordCredentials>)new UsernamePasswordBinding(varName, credentialsId));
            bindings.add((MultiBinding<StandardUsernamePasswordCredentials>)new UsernamePasswordMultiBinding(varName + "_USR", varName + "_PSW", credentialsId));
            return bindings;
        }

        @Override
        @Nonnull
        public Class<? extends StandardCredentials> type() {
            return StandardUsernamePasswordCredentials.class;
        }

        @Override
        @Nonnull
        public List<Map<String, Object>> getWithCredentialsParameters(String credentialsId) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("$class", UsernamePasswordBinding.class.getName());
            map.put("variable", new EnvVarResolver());
            map.put("credentialsId", credentialsId);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("$class", UsernamePasswordMultiBinding.class.getName());
            map2.put("usernameVariable", new EnvVarResolver("%s_USR"));
            map2.put("passwordVariable", new EnvVarResolver("%s_PSW"));
            map2.put("credentialsId", credentialsId);
            return Arrays.asList(map, map2);
        }
    }

    public static class EnvVarResolver
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String value;

        public EnvVarResolver() {
            this.value = "%s";
        }

        public EnvVarResolver(String value) {
            this.value = value;
        }

        public String resolve(String varName) {
            return String.format(this.value, varName);
        }
    }
}

