/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.steps;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public final class EnvVarsForToolStep
extends AbstractStepImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String toolId;
    private String toolVersion;

    @DataBoundConstructor
    public EnvVarsForToolStep(String toolId, String toolVersion) {
        this.toolId = toolId;
        this.toolVersion = toolVersion;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public String getToolId() {
        return this.toolId;
    }

    public static final class EnvVarsForToolStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<List<String>> {
        @Inject
        private transient EnvVarsForToolStep step;
        @StepContextParameter
        transient TaskListener listener;
        @StepContextParameter
        transient EnvVars env;
        @StepContextParameter
        transient Node node;
        private static final long serialVersionUID = 1L;

        protected List<String> run() throws Exception {
            String toolVersion = this.step.getToolVersion();
            String toolId = this.step.getToolId();
            for (ToolDescriptor desc : ToolInstallation.all()) {
                if (toolId != null && !desc.getId().equals(toolId)) continue;
                for (ToolInstallation tool : desc.getInstallations()) {
                    if (!tool.getName().equals(toolVersion)) continue;
                    if (tool instanceof NodeSpecific) {
                        tool = (ToolInstallation)((NodeSpecific)tool).forNode(this.node, this.listener);
                    }
                    if (tool instanceof EnvironmentSpecific) {
                        tool = (ToolInstallation)((EnvironmentSpecific)tool).forEnvironment(this.env);
                    }
                    ArrayList<String> toolEnvList = new ArrayList<String>();
                    EnvVars toolEnv = new EnvVars();
                    tool.buildEnvVars(toolEnv);
                    for (Map.Entry entry : toolEnv.entrySet()) {
                        toolEnvList.add((String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                    return toolEnvList;
                }
            }
            throw new AbortException("No tool of type " + toolId + " named " + toolVersion + " found");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(EnvVarsForToolStepExecution.class);
        }

        public boolean isAdvanced() {
            return true;
        }

        public String getFunctionName() {
            return "envVarsForTool";
        }

        public String getDisplayName() {
            return "Fetches the environment variables for a given tool in a list of 'FOO=bar' strings suitable for the withEnv step.";
        }

        public boolean takesImplicitBlockArgument() {
            return false;
        }
    }
}

