/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import hudson.Extension;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMHead;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.ChangeLogStrategy;

@Extension
public class DefaultChangeLogStrategy
extends ChangeLogStrategy {
    private Class<?> bitbucketPr;
    private Class<?> githubPr;

    public DefaultChangeLogStrategy() {
        try {
            this.githubPr = Class.forName("org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead");
        }
        catch (ClassNotFoundException e) {
            this.githubPr = null;
        }
        try {
            this.bitbucketPr = Class.forName("com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead");
        }
        catch (ClassNotFoundException e) {
            this.bitbucketPr = null;
        }
    }

    protected boolean shouldExamineAllBuilds(@Nonnull SCMHead head) {
        if (this.githubPr != null && head.getClass().isAssignableFrom(this.githubPr)) {
            return true;
        }
        return this.bitbucketPr != null && head.getClass().isAssignableFrom(this.bitbucketPr);
    }
}

