/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.InvisibleAction;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.SyntheticStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.SyntheticStageNames;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.ExecutionModelAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.TagsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;

@Extension
public final class SyntheticStageGraphListener
implements GraphListener {
    private static final Logger LOGGER = Logger.getLogger(SyntheticStageGraphListener.class.getName());
    private final transient Map<FlowExecution, Boolean> declarativeRuns = new WeakHashMap<FlowExecution, Boolean>();

    public void onNewHead(FlowNode node) {
        LabelAction label;
        if (node != null && node instanceof StepStartNode && ((StepStartNode)node).getDescriptor() instanceof StageStep.DescriptorImpl && this.isDeclarativeRun(node.getExecution()) && (label = (LabelAction)node.getAction(LabelAction.class)) != null && (SyntheticStageNames.preStages().contains(label.getDisplayName()) || SyntheticStageNames.postStages().contains(label.getDisplayName()))) {
            if (SyntheticStageNames.preStages().contains(label.getDisplayName())) {
                this.attachTag(node, SyntheticStage.getPre());
            }
            if (SyntheticStageNames.postStages().contains(label.getDisplayName())) {
                this.attachTag(node, SyntheticStage.getPost());
            }
        }
    }

    private void attachTag(FlowNode currentNode, String syntheticContext) {
        TagsAction tagsAction = (TagsAction)currentNode.getAction(TagsAction.class);
        if (tagsAction == null) {
            tagsAction = new TagsAction();
            tagsAction.addTag("SYNTHETIC_STAGE", syntheticContext);
            currentNode.addAction((Action)tagsAction);
        } else if (tagsAction.getTagValue("SYNTHETIC_STAGE") == null) {
            tagsAction.addTag("SYNTHETIC_STAGE", syntheticContext);
            try {
                currentNode.save();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "failed to save actions for FlowNode id=" + currentNode.getId(), e);
            }
        }
    }

    private synchronized boolean isDeclarativeRun(@Nonnull FlowExecution execution) {
        if (!this.declarativeRuns.containsKey(execution)) {
            boolean isDeclarative = false;
            try {
                FlowExecutionOwner owner = execution.getOwner();
                if (owner != null && owner.getExecutable() instanceof Actionable && ((Actionable)owner.getExecutable()).getAction(ExecutionModelAction.class) != null) {
                    isDeclarative = true;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error loading WorkflowRun for FlowNode: {0}", e);
            }
            this.declarativeRuns.put(execution, isDeclarative);
        }
        return this.declarativeRuns.get(execution);
    }

    @Deprecated
    public static class GraphListenerAction
    extends InvisibleAction {
    }
}

