/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.actions;

import hudson.model.InvisibleAction;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.modeldefinition.options.DeclarativeOption;

public class DeclarativeJobPropertyTrackerAction
extends InvisibleAction {
    private final Set<String> jobProperties = new HashSet<String>();
    private final Set<String> triggers = new HashSet<String>();
    private final Set<String> parameters = new HashSet<String>();
    private Set<String> options = new HashSet<String>();

    @Deprecated
    public DeclarativeJobPropertyTrackerAction(@CheckForNull List<JobProperty> rawJobProperties, @CheckForNull List<Trigger> rawTriggers, @CheckForNull List<ParameterDefinition> rawParameters) {
        this(rawJobProperties, rawTriggers, rawParameters, null);
    }

    public DeclarativeJobPropertyTrackerAction(@CheckForNull List<JobProperty> rawJobProperties, @CheckForNull List<Trigger> rawTriggers, @CheckForNull List<ParameterDefinition> rawParameters, @CheckForNull List<DeclarativeOption> rawOptions) {
        if (rawJobProperties != null) {
            for (JobProperty p : rawJobProperties) {
                this.jobProperties.add(p.getDescriptor().getId());
            }
        }
        if (rawTriggers != null) {
            for (Trigger t : rawTriggers) {
                this.triggers.add(t.getDescriptor().getId());
            }
        }
        if (rawParameters != null) {
            for (ParameterDefinition d : rawParameters) {
                this.parameters.add(d.getName());
            }
        }
        if (rawOptions != null) {
            for (DeclarativeOption o : rawOptions) {
                this.options.add(o.getDescriptor().getName());
            }
        }
    }

    protected Object readResolve() throws IOException {
        if (this.options == null) {
            this.options = new HashSet<String>();
        }
        return this;
    }

    public DeclarativeJobPropertyTrackerAction(@Nonnull DeclarativeJobPropertyTrackerAction copyFrom) {
        this.jobProperties.addAll(copyFrom.getJobProperties());
        this.triggers.addAll(copyFrom.getTriggers());
        this.parameters.addAll(copyFrom.getParameters());
        this.options.addAll(copyFrom.getOptions());
    }

    public Set<String> getJobProperties() {
        return Collections.unmodifiableSet(this.jobProperties);
    }

    public Set<String> getTriggers() {
        return Collections.unmodifiableSet(this.triggers);
    }

    public Set<String> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    public Set<String> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public String toString() {
        return "DeclarativeJobPropertyTrackerAction[jobProperties:" + this.jobProperties + ",triggers:" + this.triggers + ",parameters:" + this.parameters + ",options:" + this.options + "]";
    }
}

