/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.actions;

import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public class RestartFlowFactoryAction
extends InvisibleAction
implements CpsFlowFactoryAction2,
Queue.QueueAction {
    private String originRunId;

    public RestartFlowFactoryAction(@Nonnull String originRunId) {
        this.originRunId = originRunId;
    }

    public String getOriginRunId() {
        return this.originRunId;
    }

    public boolean shouldSchedule(List<Action> actions) {
        return true;
    }

    public CpsFlowExecution create(FlowDefinition def, FlowExecutionOwner owner, List<? extends Action> actions) throws IOException {
        FlowExecutionOwner originalOwner;
        Run original = Run.fromExternalizableId((String)this.originRunId);
        String origScript = null;
        boolean origSandbox = true;
        if (original instanceof FlowExecutionOwner.Executable && (originalOwner = ((FlowExecutionOwner.Executable)original).asFlowExecutionOwner()) != null) {
            try {
                for (FlowCopier copier : ExtensionList.lookup(FlowCopier.class)) {
                    copier.copy(originalOwner, owner);
                }
            }
            catch (InterruptedException x) {
                throw new IOException("Failed to copy metadata", x);
            }
            FlowExecution origExecution = originalOwner.getOrNull();
            if (origExecution instanceof CpsFlowExecution) {
                origScript = ((CpsFlowExecution)origExecution).getScript();
                origSandbox = ((CpsFlowExecution)origExecution).isSandbox();
            }
        }
        if (origScript != null) {
            return new CpsFlowExecution(origScript, origSandbox, owner);
        }
        return null;
    }
}

