/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveGenerator;
import org.jenkinsci.plugins.pipeline.modeldefinition.withscript.WithScriptDescriptor;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.kohsuke.stapler.DataBoundConstructor;

public class AgentDirective
extends AbstractDirective<AgentDirective> {
    private DeclarativeAgent agent;

    @DataBoundConstructor
    public AgentDirective(DeclarativeAgent agent) {
        this.agent = agent;
    }

    public DeclarativeAgent getAgent() {
        return this.agent;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<AgentDirective> {
        @Override
        @Nonnull
        public String getName() {
            return "agent";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return "Agent";
        }

        @Override
        @Nonnull
        public List<Descriptor> getDescriptors() {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            List descs = DeclarativeAgentDescriptor.all().stream().sorted(Comparator.comparing(WithScriptDescriptor::getName)).collect(Collectors.toList());
            for (DeclarativeAgentDescriptor td : descs) {
                if (SymbolLookup.getSymbolValue((Object)td).isEmpty()) continue;
                descriptors.add((Descriptor)td);
            }
            return descriptors;
        }

        @Override
        @Nonnull
        public String toGroovy(@Nonnull AgentDirective directive) {
            if (directive.agent != null) {
                DeclarativeAgentDescriptor desc = directive.agent.getDescriptor();
                UninstantiatedDescribable ud = UninstantiatedDescribable.from((Object)directive.agent);
                DescribableModel model = ud.getModel();
                if (model != null) {
                    StringBuilder result = new StringBuilder();
                    if (DeclarativeAgentDescriptor.zeroArgModels().containsKey(desc.getName())) {
                        result.append("agent ").append(desc.getName());
                    } else {
                        result.append("agent {\n");
                        if (DeclarativeAgentDescriptor.noRequiredArgsModels().containsKey(desc.getName()) && ud.getArguments().entrySet().stream().allMatch(e -> e.getValue() == null || e.getValue() instanceof String && e.getValue().equals(""))) {
                            result.append(desc.getName()).append(" true\n");
                        } else if (model.hasSingleRequiredParameter() && ud.getArguments().size() == 1) {
                            result.append(Snippetizer.object2Groovy((Object)ud)).append("\n");
                        } else {
                            result.append(desc.getName()).append(" ").append(DirectiveGenerator.mapToClosure(ud.getArguments()));
                        }
                        result.append("}");
                    }
                    result.append("\n");
                    return result.toString();
                }
            }
            return "// No valid agent defined\n";
        }
    }
}

