/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class InputDirective
extends AbstractDirective<InputDirective> {
    private final String message;
    private String id;
    private String submitter;
    private String submitterParameter;
    private List<ParameterDefinition> parameters = Collections.emptyList();
    private String ok;

    @DataBoundConstructor
    public InputDirective(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    @DataBoundSetter
    public void setOk(String ok) {
        this.ok = ok;
    }

    public String getOk() {
        return this.ok;
    }

    @DataBoundSetter
    public void setSubmitterParameter(String submitterParameter) {
        this.submitterParameter = submitterParameter;
    }

    public String getSubmitterParameter() {
        return this.submitterParameter;
    }

    @DataBoundSetter
    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setParameters(List<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<InputDirective> {
        @Override
        @Nonnull
        public String getName() {
            return "input";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return "Input";
        }

        @Override
        @Nonnull
        public List<Descriptor> getDescriptors() {
            return Collections.singletonList(StepDescriptor.byFunctionName((String)"input"));
        }

        public Descriptor getInputDescriptor() {
            return StepDescriptor.byFunctionName((String)"input");
        }

        public FormValidation doCheckMessage(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Input message must be provided.");
            }
            return FormValidation.ok();
        }

        @Override
        @Nonnull
        public String toGroovy(@Nonnull InputDirective directive) {
            if (directive.getMessage() != null) {
                StringBuilder result = new StringBuilder("input {\n");
                result.append("message ").append(Snippetizer.object2Groovy((Object)directive.getMessage())).append("\n");
                if (!StringUtils.isEmpty((String)directive.getId())) {
                    result.append("id ").append(Snippetizer.object2Groovy((Object)directive.getId())).append("\n");
                }
                if (!StringUtils.isEmpty((String)directive.getOk())) {
                    result.append("ok ").append(Snippetizer.object2Groovy((Object)directive.getOk())).append("\n");
                }
                if (!StringUtils.isEmpty((String)directive.getSubmitter())) {
                    result.append("submitter ").append(Snippetizer.object2Groovy((Object)directive.getSubmitter())).append("\n");
                }
                if (!StringUtils.isEmpty((String)directive.getSubmitterParameter())) {
                    result.append("submitterParameter ").append(Snippetizer.object2Groovy((Object)directive.getSubmitterParameter())).append("\n");
                }
                if (!directive.getParameters().isEmpty()) {
                    result.append("parameters {\n");
                    for (ParameterDefinition p : directive.getParameters()) {
                        result.append(Snippetizer.object2Groovy((Object)UninstantiatedDescribable.from((Object)p))).append("\n");
                    }
                    result.append("}\n");
                }
                result.append("}\n");
                return result.toString();
            }
            return "// Input not defined\n";
        }
    }
}

