/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.JobPropertyDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.model.Options;
import org.jenkinsci.plugins.pipeline.modeldefinition.options.DeclarativeOptionDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.BlockedStepsAndMethodCalls;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class OptionsDirective
extends AbstractDirective<OptionsDirective> {
    public static final List<String> ADDITIONAL_BLOCKED_STEPS = ImmutableList.of((Object)"script", (Object)"ws", (Object)"withEnv", (Object)"withCredentials", (Object)"withContext", (Object)"waitUntil", (Object)"catchError");
    private List<Describable> options = new ArrayList<Describable>();

    @DataBoundConstructor
    public OptionsDirective(List<Describable> options) {
        if (options != null) {
            this.options.addAll(options);
        }
    }

    @Nonnull
    public List<Describable> getOptions() {
        return this.options;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<OptionsDirective> {
        @Override
        @Nonnull
        public String getName() {
            return "options";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return "Options";
        }

        @Override
        @Nonnull
        public List<Descriptor> getDescriptors() {
            return this.getDescriptorsForContext(false);
        }

        @Nonnull
        public List<Descriptor> getDescriptorsForContext(boolean inStage) {
            ArrayList<Object> descriptors = new ArrayList<Object>();
            for (Descriptor d2 : ExtensionList.lookup(JobPropertyDescriptor.class)) {
                Set symbolValue = SymbolLookup.getSymbolValue((Object)d2);
                if (symbolValue.isEmpty()) continue;
                boolean blockedSymbol = false;
                for (String symbol : symbolValue) {
                    if (!Options.getBLOCKED_PROPERTIES().contains(symbol)) continue;
                    blockedSymbol = true;
                }
                if (blockedSymbol || inStage) continue;
                descriptors.add(d2);
            }
            for (Descriptor d2 : ExtensionList.lookup(DeclarativeOptionDescriptor.class)) {
                if (SymbolLookup.getSymbolValue((Object)d2).isEmpty() || (inStage || d2.isStageOnly()) && !d2.canUseInStage()) continue;
                descriptors.add(d2);
            }
            for (StepDescriptor sd : StepDescriptor.all()) {
                if (!sd.takesImplicitBlockArgument() || BlockedStepsAndMethodCalls.blockedInMethodCalls().containsKey(sd.getFunctionName()) || sd.getRequiredContext().contains(Launcher.class) || sd.getRequiredContext().contains(FilePath.class) || ADDITIONAL_BLOCKED_STEPS.contains(sd.getFunctionName())) continue;
                descriptors.add(sd);
            }
            return descriptors.stream().filter(d -> DirectiveDescriptor.symbolForDescriptor(d) != null).sorted(Comparator.comparing(d -> DirectiveDescriptor.symbolForDescriptor(d))).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public String toGroovy(@Nonnull OptionsDirective directive) {
            StringBuilder result = new StringBuilder("options {\n");
            for (Describable d : directive.options) {
                if (d instanceof Step) {
                    String origGroovy = Snippetizer.object2Groovy((Object)d);
                    result.append(origGroovy.substring(0, origGroovy.length() - " {\n    // some block\n}".length()));
                    result.append("\n");
                    continue;
                }
                result.append(Snippetizer.object2Groovy((Object)UninstantiatedDescribable.from((Object)d)));
                result.append("\n");
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

