/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.model;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.StageStatus;
import org.jenkinsci.plugins.pipeline.modeldefinition.model.Messages;

public abstract class SkippedStageReason
implements Serializable {
    protected String stageName;

    public SkippedStageReason(@Nonnull String stageName) {
        this.stageName = stageName;
    }

    public boolean isNotExecutedNode() {
        return false;
    }

    @Nonnull
    public abstract String getMessage();

    @Nonnull
    public abstract String getStageStatus();

    @Nonnull
    public abstract SkippedStageReason cloneWithNewStage(@Nonnull String var1);

    @Nonnull
    public String getStageName() {
        return this.stageName;
    }

    public static class Restart
    extends SkippedStageReason {
        private String restartedStage;
        private static final long serialVersionUID = 1L;

        public Restart(@Nonnull String stageName, @Nonnull String restartedStage) {
            super(stageName);
            this.restartedStage = restartedStage;
        }

        public String getRestartedStage() {
            return this.restartedStage;
        }

        @Override
        public boolean isNotExecutedNode() {
            return true;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return Messages.SkippedStageReason_RESTART_Message(this.stageName, this.restartedStage);
        }

        @Override
        @Nonnull
        public String getStageStatus() {
            return StageStatus.getSkippedForRestart();
        }

        @Override
        @Nonnull
        public SkippedStageReason cloneWithNewStage(@Nonnull String newStage) {
            return new Restart(newStage, this.restartedStage);
        }
    }

    public static class When
    extends SkippedStageReason {
        private static final long serialVersionUID = 1L;

        public When(@Nonnull String stageName) {
            super(stageName);
        }

        @Override
        @Nonnull
        public String getMessage() {
            return Messages.SkippedStageReason_WHEN_Message(this.stageName);
        }

        @Override
        @Nonnull
        public String getStageStatus() {
            return StageStatus.getSkippedForConditional();
        }

        @Override
        @Nonnull
        public SkippedStageReason cloneWithNewStage(@Nonnull String newStage) {
            return new When(newStage);
        }
    }

    public static class Unstable
    extends SkippedStageReason {
        private static final long serialVersionUID = 1L;

        public Unstable(@Nonnull String stageName) {
            super(stageName);
        }

        @Override
        @Nonnull
        public String getMessage() {
            return Messages.SkippedStageReason_UNSTABLE_Message(this.stageName);
        }

        @Override
        @Nonnull
        public String getStageStatus() {
            return StageStatus.getSkippedForUnstable();
        }

        @Override
        @Nonnull
        public SkippedStageReason cloneWithNewStage(@Nonnull String newStage) {
            return new Unstable(newStage);
        }
    }

    public static class Failure
    extends SkippedStageReason {
        private static final long serialVersionUID = 1L;

        public Failure(@Nonnull String stageName) {
            super(stageName);
        }

        @Override
        @Nonnull
        public String getMessage() {
            return Messages.SkippedStageReason_FAILURE_Message(this.stageName);
        }

        @Override
        @Nonnull
        public String getStageStatus() {
            return StageStatus.getSkippedForFailure();
        }

        @Override
        @Nonnull
        public SkippedStageReason cloneWithNewStage(@Nonnull String newStage) {
            return new Failure(newStage);
        }
    }
}

