/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.parser;

import com.cloudbees.groovy.cps.NonCPS;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ModelParser;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

@Extension
public class GroovyShellDecoratorImpl
extends GroovyShellDecorator {
    private static final Logger LOGGER = Logger.getLogger(GroovyShellDecoratorImpl.class.getName());

    public GroovyShellDecorator forTrusted() {
        return this;
    }

    public void configureCompiler(final @CheckForNull CpsFlowExecution execution, CompilerConfiguration cc) {
        ImportCustomizer ic = new ImportCustomizer();
        ic.addStarImports(new String[]{NonCPS.class.getPackage().getName()});
        ic.addStarImports(new String[]{"hudson.model", "jenkins.model"});
        this.customizeImports(execution, ic);
        cc.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new CompilationCustomizer(CompilePhase.SEMANTIC_ANALYSIS){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                boolean doModelParsing = false;
                if (context.getCompileUnit().getCodeSource().getLocation().toString().equals("file:/groovy/shell") && classNode.isScript()) {
                    doModelParsing = true;
                } else if (execution != null && classNode.getPackageName() == null) {
                    try {
                        FlowExecutionOwner owner = execution.getOwner();
                        if (owner != null && owner.getExecutable() instanceof Run) {
                            Run run = (Run)owner.getExecutable();
                            for (GlobalVariable v : GlobalVariable.forRun((Run)run)) {
                                if (!classNode.getNameWithoutPackage().equals(v.getName())) continue;
                                doModelParsing = true;
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Error loading WorkflowRun for execution: {0}", e);
                    }
                }
                if (doModelParsing) {
                    new ModelParser(source, (FlowExecution)execution).parse();
                }
            }
        }});
    }
}

