/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.Converter;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public final class ValidateDeclarativePipelineStep
extends AbstractStepImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;

    @DataBoundConstructor
    public ValidateDeclarativePipelineStep(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public static final class ValidateDeclarativePipelineStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        @Inject
        private transient ValidateDeclarativePipelineStep step;
        @StepContextParameter
        private transient FilePath cwd;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        public Boolean run() throws Exception {
            if (StringUtils.isEmpty((String)this.step.getPath())) {
                this.listener.getLogger().println("No Declarative Pipeline file specified.");
                return false;
            }
            FilePath f = this.cwd.child(this.step.getPath());
            if (!f.exists() || f.isDirectory()) {
                this.listener.getLogger().println("Declarative Pipeline file '" + this.step.getPath() + "' does not exist.");
                return false;
            }
            String text = f.readToString();
            if (StringUtils.isEmpty((String)text)) {
                this.listener.getLogger().println("Declarative Pipeline file '" + this.step.getPath() + "' is empty.");
                return false;
            }
            try {
                ModelASTPipelineDef pipelineDef = Converter.scriptToPipelineDef(text);
                if (pipelineDef != null) {
                    this.listener.getLogger().println("Declarative Pipeline file '" + this.step.getPath() + "' is valid.");
                    return true;
                }
                this.listener.getLogger().println("Declarative Pipeline file '" + this.step.getPath() + "' does not contain the 'pipeline' step.");
                return false;
            }
            catch (Exception e) {
                this.listener.getLogger().println("Error(s) validating Declarative Pipeline file '" + this.step.getPath() + "' - " + e.toString());
                return false;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(ValidateDeclarativePipelineStepExecution.class);
        }

        public String getFunctionName() {
            return "validateDeclarativePipeline";
        }

        public String getDisplayName() {
            return "Validate a file containing a Declarative Pipeline";
        }
    }
}

