/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.utils;

import hudson.util.ListBoxModel;
import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.Messages;
import org.jvnet.localizer.Localizable;

public enum Comparator {
    GLOB(Messages._Comparator_GLOB_DisplayName()){

        @Override
        public boolean compare(@Nonnull String pattern, String actual) {
            actual = StringUtils.defaultIfBlank((String)actual, (String)"");
            String safeCompare = pattern.replace('/', File.separatorChar);
            String safeName = actual.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safeCompare, (String)safeName, (boolean)false);
        }
    }
    ,
    REGEXP(Messages._Comparator_REGEXP_DisplayName()){

        @Override
        public boolean compare(@Nonnull String pattern, String actual) {
            actual = StringUtils.defaultIfBlank((String)actual, (String)"");
            return actual.matches(pattern);
        }
    }
    ,
    EQUALS(Messages._Comparator_EQUALS_DisplayName()){

        @Override
        public boolean compare(@Nonnull String pattern, String actual) {
            actual = StringUtils.defaultIfBlank((String)actual, (String)"");
            return actual.equals(pattern);
        }
    };

    private final Localizable displayName;

    private Comparator(Localizable displayName) {
        this.displayName = displayName;
    }

    public Localizable getDisplayName() {
        return this.displayName;
    }

    public abstract boolean compare(String var1, String var2);

    public static Comparator get(String name, Comparator defaultValue) {
        if (StringUtils.isEmpty((String)name)) {
            return defaultValue;
        }
        for (Comparator comparator : Comparator.values()) {
            if (!name.equalsIgnoreCase(comparator.name())) continue;
            return comparator;
        }
        return defaultValue;
    }

    public static ListBoxModel getSelectOptions(boolean emptySelection, Comparator top) {
        ListBoxModel model = new ListBoxModel();
        if (emptySelection) {
            model.add("");
        }
        if (top != null) {
            model.add(top.getDisplayName().toString(), top.name());
        }
        for (Comparator comparator : Comparator.values()) {
            if (comparator == top) continue;
            model.add(comparator.getDisplayName().toString(), comparator.name());
        }
        return model;
    }
}

