/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.util.VersionNumber;
import java.io.File;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.CompatibilityLoader;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Extension
public final class Upgrade
extends GroovyShellDecorator {
    private static final Logger LOGGER = Logger.getLogger(Upgrade.class.getName());

    public void configureShell(CpsFlowExecution context, GroovyShell shell) {
        if (context == null) {
            return;
        }
        FlowExecutionOwner owner = context.getOwner();
        if (owner == null) {
            return;
        }
        try {
            if (!Upgrade.isOld(owner)) {
                LOGGER.fine(() -> String.valueOf(context) + " does not seem to be old");
                return;
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "failed to check " + String.valueOf(context), x);
            return;
        }
        GroovyClassLoader cl = shell.getClassLoader();
        GroovyResourceLoader base = cl.getResourceLoader();
        cl.setResourceLoader(filename -> {
            for (CompatibilityLoader loader : ExtensionList.lookup(CompatibilityLoader.class)) {
                URL url = loader.loadGroovySource(filename);
                if (url == null) continue;
                LOGGER.fine(() -> "for " + String.valueOf(context) + " loading " + filename + " via " + String.valueOf(loader) + " \u21d2 " + String.valueOf(url));
                return url;
            }
            URL url = base.loadGroovySource(filename);
            if (url != null) {
                LOGGER.finer(() -> "for " + String.valueOf(context) + " loading " + filename + " \u21d2 " + String.valueOf(url));
            }
            return url;
        });
    }

    public GroovyShellDecorator forTrusted() {
        return this;
    }

    private static boolean isOld(FlowExecutionOwner owner) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newDefaultInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        SAXParser parser = factory.newSAXParser();
        final AtomicBoolean old = new AtomicBoolean();
        final File buildXml = new File(owner.getRootDir(), "build.xml");
        parser.parse(buildXml, new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                int at;
                String plugin = attributes.getValue("plugin");
                if (plugin != null && (at = plugin.indexOf(64)) != -1 && plugin.substring(0, at).equals("pipeline-model-definition")) {
                    VersionNumber version = new VersionNumber(plugin.substring(at + 1));
                    LOGGER.fine(() -> "got " + String.valueOf(version) + " off " + qName + " in " + String.valueOf(buildXml));
                    if (version.isOlderThan(new VersionNumber("2.2234"))) {
                        old.set(true);
                    }
                }
            }
        });
        return old.get();
    }

    @Extension
    public static final class Loader
    implements CompatibilityLoader {
        private static final Set<String> CLASSES = Set.of("org.jenkinsci.plugins.pipeline.modeldefinition.ModelInterpreter", "org.jenkinsci.plugins.pipeline.modeldefinition.agent.CheckoutScript", "org.jenkinsci.plugins.pipeline.modeldefinition.agent.impl.AnyScript", "org.jenkinsci.plugins.pipeline.modeldefinition.agent.impl.LabelScript", "org.jenkinsci.plugins.pipeline.modeldefinition.agent.impl.NoneScript");

        public URL loadGroovySource(String clazz) {
            if (CLASSES.contains(clazz)) {
                return Upgrade.class.getResource("compat/" + clazz.replaceFirst(".+[.]", "") + ".groovy");
            }
            return null;
        }
    }
}

