/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.handlers.GenericItemOptionHandler;
import hudson.model.Job;
import hudson.model.Run;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.RestartDeclarativePipelineAction;
import org.jenkinsci.plugins.pipeline.modeldefinition.cli.Messages;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Setter;

@Extension
public class RestartFromStageCommand
extends CLICommand {
    @Option(required=true, name="-j", aliases={"--job"}, metaVar="JOB", usage="Name of the job to restart.", handler=JobHandler.class)
    public Job<?, ?> job;
    @Option(required=true, name="-s", aliases={"--stage"}, metaVar="STAGE", usage="Stage to restart from.")
    public String stage;
    @Option(name="-n", aliases={"--number"}, metaVar="BUILD#", usage="Build to restart, if not the last.")
    public int number;

    public String getShortDescription() {
        return Messages.RestartFromStageCommand_ShortDescription();
    }

    protected int run() throws Exception {
        Run run;
        Run run2 = run = this.number <= 0 ? this.job.getLastBuild() : this.job.getBuildByNumber(this.number);
        if (run == null) {
            throw new AbortException("No such build");
        }
        RestartDeclarativePipelineAction action = (RestartDeclarativePipelineAction)run.getAction(RestartDeclarativePipelineAction.class);
        if (action == null) {
            throw new AbortException("Not a Declarative Pipeline build");
        }
        if (!action.isRestartEnabled()) {
            throw new AbortException("Not authorized to restart builds of this job");
        }
        if (!action.getRestartableStages().contains(this.stage)) {
            throw new AbortException("Stage " + this.stage + " either does not exist in the build, or did not run in the build, and so cannot be restarted.");
        }
        action.run(this.stage);
        return 0;
    }

    public static class JobHandler
    extends GenericItemOptionHandler<Job> {
        public JobHandler(CmdLineParser parser, OptionDef option, Setter<Job> setter) {
            super(parser, option, setter);
        }

        protected Class<Job> type() {
            return Job.class;
        }
    }
}

