/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.kohsuke.stapler.DataBoundConstructor;

public class TriggersDirective
extends AbstractDirective<TriggersDirective> {
    private List<Trigger> triggers = new ArrayList<Trigger>();

    @DataBoundConstructor
    public TriggersDirective(List<Trigger> triggers) {
        if (triggers != null) {
            this.triggers.addAll(triggers);
        }
    }

    @NonNull
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<TriggersDirective> {
        @Override
        @NonNull
        public String getName() {
            return "triggers";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Triggers";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            return ExtensionList.lookup(TriggerDescriptor.class).stream().filter(d -> DirectiveDescriptor.symbolForDescriptor((Descriptor)d) != null).sorted(Comparator.comparing(d -> DirectiveDescriptor.symbolForDescriptor((Descriptor)d))).collect(Collectors.toList());
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull TriggersDirective directive) {
            StringBuilder result = new StringBuilder("triggers {\n");
            for (Trigger trigger : directive.triggers) {
                result.append(Snippetizer.object2Groovy((Object)UninstantiatedDescribable.from((Object)trigger)));
                result.append("\n");
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

