/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.ListBoxModel;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.utils.Comparator;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.utils.EnvironmentNames;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ChangeRequestConditional
extends DeclarativeStageConditional<ChangeRequestConditional> {
    private String id;
    private String target;
    private String branch;
    private String fork;
    private String url;
    private String title;
    private String author;
    private String authorDisplayName;
    private String authorEmail;
    private String comparator;

    @DataBoundConstructor
    public ChangeRequestConditional() {
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = id;
    }

    public String getTarget() {
        return this.target;
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.target = target;
    }

    public String getBranch() {
        return this.branch;
    }

    @DataBoundSetter
    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getFork() {
        return this.fork;
    }

    @DataBoundSetter
    public void setFork(String fork) {
        this.fork = fork;
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    @DataBoundSetter
    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthorDisplayName() {
        return this.authorDisplayName;
    }

    @DataBoundSetter
    public void setAuthorDisplayName(String authorDisplayName) {
        this.authorDisplayName = authorDisplayName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    @DataBoundSetter
    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public String getComparator() {
        return this.comparator;
    }

    @DataBoundSetter
    public void setComparator(String comparator) {
        Comparator c = Comparator.get(comparator, null);
        this.comparator = c != null ? c.name() : null;
    }

    public boolean matches(EnvVars vars) {
        if (!EnvironmentNames.CHANGE_ID.exists(vars)) {
            return false;
        }
        Comparator c = Comparator.get(this.comparator, Comparator.EQUALS);
        try {
            this.check(this.id, c, EnvironmentNames.CHANGE_ID, vars);
            this.check(this.target, c, EnvironmentNames.CHANGE_TARGET, vars);
            this.check(this.branch, c, EnvironmentNames.CHANGE_BRANCH, vars);
            this.check(this.fork, c, EnvironmentNames.CHANGE_FORK, vars);
            this.check(this.title, c, EnvironmentNames.CHANGE_TITLE, vars);
            this.check(this.author, c, EnvironmentNames.CHANGE_AUTHOR, vars);
            this.check(this.authorDisplayName, c, EnvironmentNames.CHANGE_AUTHOR_DISPLAY_NAME, vars);
            this.check(this.authorEmail, c, EnvironmentNames.CHANGE_AUTHOR_EMAIL, vars);
            return true;
        }
        catch (AssertionError e) {
            return false;
        }
    }

    private void check(String pattern, Comparator comparator, EnvironmentNames varName, EnvVars vars) {
        if (StringUtils.isNotEmpty((String)pattern) && !comparator.compare(pattern, varName.get(vars))) {
            throw new AssertionError((Object)(varName.name() + "(" + varName.get(vars) + ") does not match " + pattern));
        }
    }

    @Extension
    @Symbol(value={"changeRequest"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<ChangeRequestConditional> {
        public String getDisplayName() {
            return "Execute the stage if the build is on a change request";
        }

        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }

        public ListBoxModel doFillComparatorItems() {
            return Comparator.getSelectOptions(true, Comparator.EQUALS);
        }
    }
}

