/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.utils.Comparator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TagConditional
extends DeclarativeStageConditional<TagConditional> {
    private final String pattern;
    private String comparator;

    @DataBoundConstructor
    public TagConditional(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getComparator() {
        return this.comparator;
    }

    @DataBoundSetter
    public void setComparator(String comparator) {
        Comparator c = Comparator.get(comparator, null);
        this.comparator = c != null ? c.name() : null;
    }

    public boolean tagMatches(String actualTag) {
        if (StringUtils.isEmpty((String)actualTag)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.pattern) && StringUtils.isNotEmpty((String)actualTag)) {
            return true;
        }
        Comparator c = Comparator.get(this.comparator, Comparator.GLOB);
        return c.compare(this.pattern, actualTag);
    }

    @Extension
    @Symbol(value={"tag"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<TagConditional> {
        public String getDisplayName() {
            return "Execute this stage if the build is running against an SCM tag matching the given pattern";
        }

        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }

        public ListBoxModel doFillComparatorItems() {
            return Comparator.getSelectOptions(true, Comparator.GLOB);
        }
    }
}

