/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AxisDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class AxesDirective
extends AbstractDirective<AxesDirective> {
    private List<AbstractDirective> axis;

    @DataBoundConstructor
    public AxesDirective(List<AbstractDirective> axis) {
        this.axis = axis;
    }

    public List<AbstractDirective> getAxis() {
        return this.axis;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<AxesDirective> {
        @Override
        @NonNull
        public boolean isTopLevel() {
            return false;
        }

        @Override
        @NonNull
        public String getName() {
            return "axes";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Axes";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            descriptors.add(Jenkins.get().getDescriptorByType(AxisDirective.DescriptorImpl.class));
            return descriptors;
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull AxesDirective axes) {
            StringBuffer result = new StringBuffer("axes {\n");
            if (axes.axis != null) {
                axes.axis.stream().forEach(axis -> result.append(axis.toGroovy(false)));
            }
            result.append("\n}");
            return result.toString();
        }
    }
}

