/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.ExcludeDirective;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExcludesDirective
extends AbstractDirective<ExcludesDirective> {
    private List<AbstractDirective> excludes;

    @DataBoundConstructor
    public ExcludesDirective(List<AbstractDirective> excludes) {
        this.excludes = excludes;
    }

    public List<AbstractDirective> getExcludes() {
        return this.excludes;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<ExcludesDirective> {
        @Override
        @NonNull
        public boolean isTopLevel() {
            return false;
        }

        @Override
        @NonNull
        public String getName() {
            return "excludes";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Excludes";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            descriptors.add(Jenkins.get().getDescriptorByType(ExcludeDirective.DescriptorImpl.class));
            return descriptors;
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull ExcludesDirective excludes) {
            StringBuilder result = new StringBuilder("excludes {\n");
            if (excludes.excludes != null) {
                excludes.excludes.stream().forEach(d -> result.append(d.toGroovy(false)).append("\n"));
            }
            result.append("}");
            return result.toString();
        }
    }
}

