/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import org.jenkinsci.plugins.pipeline.StageStatus;
import org.jenkinsci.plugins.pipeline.modeldefinition.model.Messages;

public abstract class SkippedStageReason
implements Serializable {
    protected String stageName;

    public SkippedStageReason(@NonNull String stageName) {
        this.stageName = stageName;
    }

    public boolean isNotExecutedNode() {
        return false;
    }

    @NonNull
    public abstract String getMessage();

    @NonNull
    public abstract String getStageStatus();

    @NonNull
    public abstract SkippedStageReason cloneWithNewStage(@NonNull String var1);

    @NonNull
    public String getStageName() {
        return this.stageName;
    }

    public static class Restart
    extends SkippedStageReason {
        private String restartedStage;
        private static final long serialVersionUID = 1L;

        public Restart(@NonNull String stageName, @NonNull String restartedStage) {
            super(stageName);
            this.restartedStage = restartedStage;
        }

        public String getRestartedStage() {
            return this.restartedStage;
        }

        @Override
        public boolean isNotExecutedNode() {
            return true;
        }

        @Override
        @NonNull
        public String getMessage() {
            return Messages.SkippedStageReason_RESTART_Message(this.stageName, this.restartedStage);
        }

        @Override
        @NonNull
        public String getStageStatus() {
            return StageStatus.getSkippedForRestart();
        }

        @Override
        @NonNull
        public SkippedStageReason cloneWithNewStage(@NonNull String newStage) {
            return new Restart(newStage, this.restartedStage);
        }
    }

    public static class When
    extends SkippedStageReason {
        private static final long serialVersionUID = 1L;

        public When(@NonNull String stageName) {
            super(stageName);
        }

        @Override
        @NonNull
        public String getMessage() {
            return Messages.SkippedStageReason_WHEN_Message(this.stageName);
        }

        @Override
        @NonNull
        public String getStageStatus() {
            return StageStatus.getSkippedForConditional();
        }

        @Override
        @NonNull
        public SkippedStageReason cloneWithNewStage(@NonNull String newStage) {
            return new When(newStage);
        }
    }

    public static class Unstable
    extends SkippedStageReason {
        private static final long serialVersionUID = 1L;

        public Unstable(@NonNull String stageName) {
            super(stageName);
        }

        @Override
        @NonNull
        public String getMessage() {
            return Messages.SkippedStageReason_UNSTABLE_Message(this.stageName);
        }

        @Override
        @NonNull
        public String getStageStatus() {
            return StageStatus.getSkippedForUnstable();
        }

        @Override
        @NonNull
        public SkippedStageReason cloneWithNewStage(@NonNull String newStage) {
            return new Unstable(newStage);
        }
    }

    public static class Failure
    extends SkippedStageReason {
        private static final long serialVersionUID = 1L;

        public Failure(@NonNull String stageName) {
            super(stageName);
        }

        @Override
        @NonNull
        public String getMessage() {
            return Messages.SkippedStageReason_FAILURE_Message(this.stageName);
        }

        @Override
        @NonNull
        public String getStageStatus() {
            return StageStatus.getSkippedForFailure();
        }

        @Override
        @NonNull
        public SkippedStageReason cloneWithNewStage(@NonNull String newStage) {
            return new Failure(newStage);
        }
    }
}

