/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.model;

import hudson.ExtensionComponent;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Result;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public abstract class BuildCondition
implements Serializable,
ExtensionPoint {
    private static final long serialVersionUID = 1L;

    @Deprecated
    public boolean meetsCondition(@Nonnull WorkflowRun r) {
        if (Util.isOverridden(BuildCondition.class, this.getClass(), (String)"meetsCondition", (Class[])new Class[]{WorkflowRun.class, Object.class, Throwable.class})) {
            return this.meetsCondition(r, (Object)null, (Throwable)null);
        }
        throw new IllegalStateException(this.getClass().getName() + " must override meetsCondition(WorkflowRun,Object,Throwable)");
    }

    public boolean meetsCondition(@Nonnull WorkflowRun r, Object context, Throwable error) {
        return this.meetsCondition(r);
    }

    @Deprecated
    public boolean meetsCondition(@Nonnull Object runWrapperObj) {
        return this.meetsCondition(runWrapperObj, null, null);
    }

    public boolean meetsCondition(@Nonnull Object runWrapperObj, Object context, Throwable error) {
        RunWrapper runWrapper = (RunWrapper)runWrapperObj;
        WorkflowRun run = (WorkflowRun)runWrapper.getRawBuild();
        return run != null && this.meetsCondition(run, context, error);
    }

    @Nonnull
    protected final Result combineResults(@Nonnull WorkflowRun run) {
        Result execResult = this.getExecutionResult(run);
        Result prevResult = run.getResult();
        if (prevResult == null) {
            prevResult = Result.SUCCESS;
        }
        if (execResult == null) {
            return Result.SUCCESS;
        }
        return execResult.combine(prevResult);
    }

    @CheckForNull
    protected Result getExecutionResult(@Nonnull WorkflowRun r) {
        FlowExecution execution = r.getExecution();
        if (execution instanceof CpsFlowExecution) {
            return ((CpsFlowExecution)execution).getResult();
        }
        return r.getResult();
    }

    public abstract String getDescription();

    public static ExtensionList<BuildCondition> all() {
        return ExtensionList.lookup(BuildCondition.class);
    }

    public static List<String> getOrderedConditionNames() {
        ArrayList<String> orderedConditions = new ArrayList<String>();
        ArrayList extensionComponents = new ArrayList(BuildCondition.all().getComponents());
        Collections.sort(extensionComponents);
        for (ExtensionComponent extensionComponent : extensionComponents) {
            BuildCondition b = (BuildCondition)extensionComponent.getInstance();
            Set symbolValues = SymbolLookup.getSymbolValue((Object)b);
            if (symbolValues.isEmpty()) continue;
            orderedConditions.add((String)symbolValues.iterator().next());
        }
        return orderedConditions;
    }

    public static Map<String, BuildCondition> getConditionMethods() {
        HashMap<String, BuildCondition> conditions = new HashMap<String, BuildCondition>();
        for (BuildCondition b : BuildCondition.all()) {
            Set symbolValues = SymbolLookup.getSymbolValue((Object)b);
            if (symbolValues.isEmpty()) continue;
            conditions.put((String)symbolValues.iterator().next(), b);
        }
        return conditions;
    }
}

