/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;

public class CommonUtils {
    public static Predicate<FlowNode> isStageWithOptionalName(final String stageName) {
        return new Predicate<FlowNode>(){

            public boolean apply(@Nullable FlowNode input) {
                if (input != null) {
                    if (input instanceof StepStartNode && ((StepStartNode)input).getDescriptor() instanceof StageStep.DescriptorImpl && (stageName == null || input.getDisplayName().equals(stageName))) {
                        return true;
                    }
                    ThreadNameAction action = (ThreadNameAction)input.getAction(ThreadNameAction.class);
                    if (input.getAction(LabelAction.class) != null && action != null && (stageName == null || action.getThreadName().equals(stageName))) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Predicate<FlowNode> isStageWithOptionalName() {
        return CommonUtils.isStageWithOptionalName(null);
    }

    public static List<FlowNode> findPossiblyUnfinishedEndNodeForCurrentStage(String stageName, FlowExecution execution) {
        if (execution == null) {
            CpsThread thread = CpsThread.current();
            execution = thread.getExecution();
        }
        ForkScanner scanner = new ForkScanner();
        FlowNode stage = scanner.findFirstMatch((Collection)execution.getCurrentHeads(), null, CommonUtils.isStageWithOptionalName(stageName));
        FlowNode finalNode = execution.getCurrentHeads().stream().filter(h -> CommonUtils.isSomewhereWithinStage(stage).apply(h)).findFirst().orElse(null);
        return Arrays.asList(stage, finalNode);
    }

    public static List<FlowNode> findPossiblyUnfinishedEndNodeForCurrentStage(String stageName) {
        return CommonUtils.findPossiblyUnfinishedEndNodeForCurrentStage(stageName, null);
    }

    public static Predicate<FlowNode> isSomewhereWithinStage(final FlowNode stageStartNode) {
        return new Predicate<FlowNode>(){

            public boolean apply(@Nullable FlowNode input) {
                if (input != null && stageStartNode instanceof BlockStartNode) {
                    return input.getEnclosingBlocks().contains(stageStartNode);
                }
                return false;
            }
        };
    }
}

