/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionComponent;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Result;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.jenkinsci.plugins.pipeline.modeldefinition.CommonUtils;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public abstract class BuildCondition
implements Serializable,
ExtensionPoint {
    private static final long serialVersionUID = 1L;

    @Deprecated
    public boolean meetsCondition(@NonNull WorkflowRun r) {
        if (Util.isOverridden(BuildCondition.class, this.getClass(), (String)"meetsCondition", (Class[])new Class[]{WorkflowRun.class, Object.class, Throwable.class})) {
            return this.meetsCondition(r, (Object)null, (Throwable)null);
        }
        throw new IllegalStateException(this.getClass().getName() + " must override meetsCondition(WorkflowRun,Object,Throwable)");
    }

    public boolean meetsCondition(@NonNull WorkflowRun r, Object context, Throwable error) {
        return this.meetsCondition(r);
    }

    @Deprecated
    public boolean meetsCondition(@NonNull Object runWrapperObj) {
        return this.meetsCondition(runWrapperObj, null, null);
    }

    public boolean meetsCondition(@NonNull Object runWrapperObj, Object context, Throwable error) {
        RunWrapper runWrapper = (RunWrapper)runWrapperObj;
        WorkflowRun run = (WorkflowRun)runWrapper.getRawBuild();
        return run != null && this.meetsCondition(run, context, error);
    }

    @Deprecated
    @NonNull
    protected final Result combineResults(@NonNull WorkflowRun run) {
        return this.combineResults(run, null);
    }

    @Deprecated
    @NonNull
    protected final Result combineResults(@NonNull WorkflowRun run, @CheckForNull Throwable error) {
        return this.combineResults(run, error, null);
    }

    @NonNull
    protected final Result combineResults(@NonNull WorkflowRun run, @CheckForNull Throwable error, @CheckForNull Object context) {
        return BuildCondition.getCombinedResult(run, error, context);
    }

    @CheckForNull
    protected Result getExecutionResult(@NonNull WorkflowRun r) {
        return BuildCondition.getFlowExecutionResult(r);
    }

    public abstract String getDescription();

    public static ExtensionList<BuildCondition> all() {
        return ExtensionList.lookup(BuildCondition.class);
    }

    public static List<String> getOrderedConditionNames() {
        ArrayList<String> orderedConditions = new ArrayList<String>();
        ArrayList extensionComponents = new ArrayList(BuildCondition.all().getComponents());
        Collections.sort(extensionComponents);
        for (ExtensionComponent extensionComponent : extensionComponents) {
            BuildCondition b = (BuildCondition)extensionComponent.getInstance();
            Set symbolValues = SymbolLookup.getSymbolValue((Object)b);
            if (symbolValues.isEmpty()) continue;
            orderedConditions.add((String)symbolValues.iterator().next());
        }
        return orderedConditions;
    }

    public static Map<String, BuildCondition> getConditionMethods() {
        HashMap<String, BuildCondition> conditions = new HashMap<String, BuildCondition>();
        for (BuildCondition b : BuildCondition.all()) {
            Set symbolValues = SymbolLookup.getSymbolValue((Object)b);
            if (symbolValues.isEmpty()) continue;
            conditions.put((String)symbolValues.iterator().next(), b);
        }
        return conditions;
    }

    @Deprecated
    @NonNull
    public static Result getCombinedResult(@NonNull WorkflowRun run, @CheckForNull Throwable error) {
        return BuildCondition.getCombinedResult(run, error, null);
    }

    @NonNull
    public static Result getCombinedResult(@NonNull WorkflowRun run, @CheckForNull Throwable error, @CheckForNull Object context) {
        WarningAction warningAction;
        DepthFirstScanner scanner;
        String stageName;
        List<FlowNode> startAndEnd;
        Result errorResult = Result.SUCCESS;
        if (context instanceof String && (startAndEnd = CommonUtils.findPossiblyUnfinishedEndNodeForCurrentStage(stageName = (String)context, run.getExecution())).size() == 2 && startAndEnd.get(0) != null && startAndEnd.get(1) != null && (scanner = new DepthFirstScanner()).setup(startAndEnd.get(1), Collections.singletonList(startAndEnd.get(0))) && (warningAction = (WarningAction)StreamSupport.stream(scanner.spliterator(), false).map(node -> (WarningAction)node.getPersistentAction(WarningAction.class)).filter(Objects::nonNull).max(Comparator.comparing(warning -> warning.getResult().ordinal)).orElse(null)) != null) {
            errorResult = warningAction.getResult();
        }
        Result execResult = BuildCondition.getFlowExecutionResult(run);
        Result prevResult = run.getResult();
        if (prevResult == null) {
            prevResult = Result.SUCCESS;
        }
        if (execResult == null) {
            execResult = Result.SUCCESS;
        }
        if (error != null) {
            errorResult = error instanceof FlowInterruptedException ? ((FlowInterruptedException)error).getResult() : Result.FAILURE;
        }
        return execResult.combine(prevResult).combine(errorResult);
    }

    @CheckForNull
    public static Result getFlowExecutionResult(@NonNull WorkflowRun r) {
        FlowExecution execution = r.getExecution();
        if (execution instanceof CpsFlowExecution) {
            return ((CpsFlowExecution)execution).getResult();
        }
        return r.getResult();
    }
}

