/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jvm.abi.AbiKmClassVisitor;
import org.jetbrains.kotlin.jvm.abi.AbiKmPackageVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.Flag;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClassVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmDeclarationContainerVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmPackageVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KotlinClassHeader;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\u001c\u0010\b\u001a\u00020\u00012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u001a\u0014\u0010\r\u001a\u00020\f*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"abiMetadataProcessor", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "annotationVisitor", "isPrivateDeclaration", "", "flags", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/Flags;", "kotlinClassHeaderVisitor", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/jvm/KotlinClassHeader;", "", "visitKotlinMetadata", "header", "jvm-abi-gen"})
public final class JvmAbiMetadataProcessorKt {
    @NotNull
    public static final AnnotationVisitor abiMetadataProcessor(@NotNull AnnotationVisitor annotationVisitor) {
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"annotationVisitor");
        return JvmAbiMetadataProcessorKt.kotlinClassHeaderVisitor((Function1<? super KotlinClassHeader, Unit>)((Function1)new Function1<KotlinClassHeader, Unit>(annotationVisitor){
            final /* synthetic */ AnnotationVisitor $annotationVisitor;
            {
                this.$annotationVisitor = $annotationVisitor;
                super(1);
            }

            public final void invoke(@NotNull KotlinClassHeader header) {
                KotlinClassHeader kotlinClassHeader;
                KmDeclarationContainerVisitor writer;
                KotlinClassMetadata metadata;
                int[] metadataVersion;
                int[] nArray;
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                int[] v = nArray = header.getMetadataVersion();
                boolean bl = false;
                Integer n = ArraysKt.getOrNull((int[])v, (int)0);
                int major = n != null ? n : 0;
                Integer n2 = ArraysKt.getOrNull((int[])v, (int)1);
                int minor = n2 != null ? n2 : 0;
                int[] nArray2 = (int[])(major > 1 || major == 1 && minor >= 4 ? nArray : null);
                if (nArray2 == null) {
                    nArray = new int[]{1, 4};
                    nArray2 = metadataVersion = nArray;
                }
                if ((metadata = KotlinClassMetadata.Companion.read(header)) instanceof KotlinClassMetadata.Class) {
                    writer = new KotlinClassMetadata.Class.Writer();
                    ((KotlinClassMetadata.Class)metadata).accept(new AbiKmClassVisitor((KmClassVisitor)writer));
                    kotlinClassHeader = ((KotlinClassMetadata.Class.Writer)writer).write(metadataVersion, header.getExtraInt()).getHeader();
                } else if (metadata instanceof KotlinClassMetadata.FileFacade) {
                    writer = new KotlinClassMetadata.FileFacade.Writer();
                    ((KotlinClassMetadata.FileFacade)metadata).accept(new AbiKmPackageVisitor((KmPackageVisitor)writer));
                    kotlinClassHeader = ((KotlinClassMetadata.FileFacade.Writer)writer).write(metadataVersion, header.getExtraInt()).getHeader();
                } else if (metadata instanceof KotlinClassMetadata.MultiFileClassPart) {
                    writer = new KotlinClassMetadata.MultiFileClassPart.Writer();
                    ((KotlinClassMetadata.MultiFileClassPart)metadata).accept(new AbiKmPackageVisitor((KmPackageVisitor)writer));
                    kotlinClassHeader = ((KotlinClassMetadata.MultiFileClassPart.Writer)writer).write(((KotlinClassMetadata.MultiFileClassPart)metadata).getFacadeClassName(), metadataVersion, header.getExtraInt()).getHeader();
                } else {
                    kotlinClassHeader = header;
                }
                KotlinClassHeader newHeader = kotlinClassHeader;
                JvmAbiMetadataProcessorKt.access$visitKotlinMetadata(this.$annotationVisitor, newHeader);
            }
        }));
    }

    private static final AnnotationVisitor kotlinClassHeaderVisitor(Function1<? super KotlinClassHeader, Unit> body) {
        return new AnnotationVisitor(body){
            private int kind;
            @NotNull
            private int[] metadataVersion;
            @NotNull
            private List<String> data1;
            @NotNull
            private List<String> data2;
            @Nullable
            private String extraString;
            @Nullable
            private String packageName;
            private int extraInt;
            final /* synthetic */ Function1<KotlinClassHeader, Unit> $body;
            {
                this.$body = $body;
                super(589824);
                this.kind = 1;
                this.metadataVersion = new int[0];
                this.data1 = new ArrayList<E>();
                this.data2 = new ArrayList<E>();
            }

            public final int getKind() {
                return this.kind;
            }

            public final void setKind(int n) {
                this.kind = n;
            }

            @NotNull
            public final int[] getMetadataVersion() {
                return this.metadataVersion;
            }

            public final void setMetadataVersion(@NotNull int[] nArray) {
                Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
                this.metadataVersion = nArray;
            }

            @NotNull
            public final List<String> getData1() {
                return this.data1;
            }

            public final void setData1(@NotNull List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data1 = list;
            }

            @NotNull
            public final List<String> getData2() {
                return this.data2;
            }

            public final void setData2(@NotNull List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data2 = list;
            }

            @Nullable
            public final String getExtraString() {
                return this.extraString;
            }

            public final void setExtraString(@Nullable String string) {
                this.extraString = string;
            }

            @Nullable
            public final String getPackageName() {
                return this.packageName;
            }

            public final void setPackageName(@Nullable String string) {
                this.packageName = string;
            }

            public final int getExtraInt() {
                return this.extraInt;
            }

            public final void setExtraInt(int n) {
                this.extraInt = n;
            }

            public void visit(@NotNull String name, @Nullable Object value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                switch (name) {
                    case "k": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.kind = (Integer)value;
                        break;
                    }
                    case "xi": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.extraInt = (Integer)value;
                        break;
                    }
                    case "mv": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.IntArray");
                        this.metadataVersion = (int[])value;
                        break;
                    }
                    case "xs": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.extraString = (String)value;
                        break;
                    }
                    case "pn": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.packageName = (String)value;
                    }
                }
            }

            @Nullable
            public AnnotationVisitor visitArray(@NotNull String name) {
                List<String> list;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"d1")) {
                    list = this.data1;
                } else if (Intrinsics.areEqual((Object)string, (Object)"d2")) {
                    list = this.data2;
                } else {
                    return null;
                }
                List<String> destination = list;
                return new AnnotationVisitor(destination){
                    final /* synthetic */ List<String> $destination;
                    {
                        this.$destination = $destination;
                        super(589824);
                    }

                    public void visit(@Nullable String name, @Nullable Object value) {
                        Collection collection = this.$destination;
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)value);
                    }
                };
            }

            public void visitEnd() {
                Integer n = this.kind;
                Collection $this$toTypedArray$iv = this.data1;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                $this$toTypedArray$iv = this.data2;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                this.$body.invoke((Object)new KotlinClassHeader(n, this.metadataVersion, stringArray, stringArray2, this.extraString, this.packageName, this.extraInt));
            }
        };
    }

    private static final void visitKotlinMetadata(AnnotationVisitor $this$visitKotlinMetadata, KotlinClassHeader header) {
        String it;
        String element$iv;
        int n;
        int n2;
        boolean $i$f$forEach;
        String[] $this$forEach$iv;
        AnnotationVisitor annotationVisitor;
        $this$visitKotlinMetadata.visit("k", (Object)header.getKind());
        $this$visitKotlinMetadata.visit("mv", (Object)header.getMetadataVersion());
        if (!(header.getData1().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u2d1 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d1");
            boolean bl = false;
            $this$forEach$iv = header.getData1();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl2 = false;
                $this$visitKotlinMetadata_u24lambda_u2d1.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u2d1.visitEnd();
        }
        if (!(header.getData2().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u2d3 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d2");
            boolean bl = false;
            $this$forEach$iv = header.getData2();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl3 = false;
                $this$visitKotlinMetadata_u24lambda_u2d3.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u2d3.visitEnd();
        }
        if (((CharSequence)header.getExtraString()).length() > 0) {
            $this$visitKotlinMetadata.visit("xs", (Object)header.getExtraString());
        }
        if (((CharSequence)header.getPackageName()).length() > 0) {
            $this$visitKotlinMetadata.visit("pn", (Object)header.getPackageName());
        }
        if (header.getExtraInt() != 0) {
            $this$visitKotlinMetadata.visit("xi", (Object)header.getExtraInt());
        }
        $this$visitKotlinMetadata.visitEnd();
    }

    private static final boolean isPrivateDeclaration(int flags) {
        return Flag.IS_PRIVATE.invoke(flags) || Flag.IS_PRIVATE_TO_THIS.invoke(flags) || Flag.IS_LOCAL.invoke(flags);
    }

    public static final /* synthetic */ boolean access$isPrivateDeclaration(int flags) {
        return JvmAbiMetadataProcessorKt.isPrivateDeclaration(flags);
    }

    public static final /* synthetic */ void access$visitKotlinMetadata(AnnotationVisitor $receiver, KotlinClassHeader header) {
        JvmAbiMetadataProcessorKt.visitKotlinMetadata($receiver, header);
    }
}

