/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.scripting.host;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.internal.scripting.host.FileBasedScriptSource;
import org.jetbrains.kotlin.buildtools.internal.scripting.host.ScriptHostUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0082\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/FileScriptSource;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/FileBasedScriptSource;", "Ljava/io/Serializable;", "file", "Ljava/io/File;", "preloadedText", "", "<init>", "(Ljava/io/File;Ljava/lang/String;)V", "getFile", "()Ljava/io/File;", "externalLocation", "Ljava/net/URL;", "getExternalLocation", "()Ljava/net/URL;", "text", "getText", "()Ljava/lang/String;", "text$delegate", "Lkotlin/Lazy;", "name", "getName", "locationId", "getLocationId", "equals", "", "other", "", "hashCode", "", "Companion", "kotlin-scripting-common"})
@SourceDebugExtension(value={"SMAP\nscriptHostUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 scriptHostUtil.kt\nkotlin/script/experimental/host/FileScriptSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public class FileScriptSource
extends FileBasedScriptSource
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @Nullable
    private final String preloadedText;
    @NotNull
    private final Lazy text$delegate;
    private static final long serialVersionUID;

    public FileScriptSource(@NotNull File file, @Nullable String preloadedText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.preloadedText = preloadedText;
        this.text$delegate = LazyKt.lazy(() -> FileScriptSource.text_delegate$lambda$0(this));
    }

    public /* synthetic */ FileScriptSource(File file, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(file, string);
    }

    @Override
    @NotNull
    public File getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public URL getExternalLocation() {
        URL uRL = this.getFile().toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @Override
    @NotNull
    public String getText() {
        Lazy lazy = this.text$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getName() {
        return this.getFile().getName();
    }

    @Override
    @Nullable
    public String getLocationId() {
        return this.getFile().getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof FileScriptSource)) return false;
        FileScriptSource fileScriptSource = (FileScriptSource)other;
        if (fileScriptSource == null) return false;
        FileScriptSource it = fileScriptSource;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)this.getFile().getAbsolutePath(), (Object)it.getFile().getAbsolutePath())) return false;
        if (!Intrinsics.areEqual((Object)ScriptHostUtilKt.access$getTextSafe(this), (Object)ScriptHostUtilKt.access$getTextSafe(it))) return false;
        return true;
    }

    public int hashCode() {
        String string = ScriptHostUtilKt.access$getTextSafe(this);
        return this.getFile().getAbsolutePath().hashCode() + (string != null ? string.hashCode() : 0) * 23;
    }

    private static final String text_delegate$lambda$0(FileScriptSource this$0) {
        String string = this$0.preloadedText;
        if (string == null) {
            string = ScriptHostUtilKt.access$readTextSkipUtf8Bom(this$0.getFile());
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/FileScriptSource$Companion;", "", "<init>", "()V", "serialVersionUID", "", "getSerialVersionUID$annotations", "kotlin-scripting-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getSerialVersionUID$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

