/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\"\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/MessageCollectorImpl;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "<init>", "()V", "_messages", "", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollectorImpl$Message;", "messages", "", "getMessages", "()Ljava/util/List;", "errors", "getErrors", "forward", "", "other", "clear", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "hasErrors", "", "toString", "Message", "util"})
@SourceDebugExtension(value={"SMAP\nMessageCollectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageCollectorImpl.kt\norg/jetbrains/kotlin/cli/common/messages/MessageCollectorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n774#2:55\n865#2,2:56\n1761#2,3:58\n*S KotlinDebug\n*F\n+ 1 MessageCollectorImpl.kt\norg/jetbrains/kotlin/cli/common/messages/MessageCollectorImpl\n*L\n17#1:55\n17#1:56,2\n38#1:58,3\n*E\n"})
public class MessageCollectorImpl
implements MessageCollector {
    @NotNull
    private final List<Message> _messages = new ArrayList();

    @NotNull
    public final List<Message> getMessages() {
        return this._messages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Message> getErrors() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getMessages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Message it = (Message)element$iv$iv;
            boolean bl = false;
            if (!it.getSeverity().isError()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void forward(@NotNull MessageCollector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (Message message2 : this._messages) {
            other.report(message2.getSeverity(), message2.getMessage(), message2.getLocation());
        }
    }

    @Override
    public void clear() {
        this._messages.clear();
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this._messages.add(new Message(severity, message2, location));
    }

    @Override
    public boolean hasErrors() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getMessages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!it.getSeverity().isError()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.getMessages(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0005H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/MessageCollectorImpl$Message;", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;)V", "getSeverity", "()Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "getMessage", "()Ljava/lang/String;", "getLocation", "()Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "util"})
    public static final class Message {
        @NotNull
        private final CompilerMessageSeverity severity;
        @NotNull
        private final String message;
        @Nullable
        private final CompilerMessageSourceLocation location;

        public Message(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.severity = severity;
            this.message = message2;
            this.location = location;
        }

        @NotNull
        public final CompilerMessageSeverity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final CompilerMessageSourceLocation getLocation() {
            return this.location;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.location != null) {
                $this$toString_u24lambda_u240.append(this.location);
                $this$toString_u24lambda_u240.append(": ");
            }
            $this$toString_u24lambda_u240.append(this.severity.getPresentableName());
            $this$toString_u24lambda_u240.append(": ");
            $this$toString_u24lambda_u240.append(this.message);
            return stringBuilder.toString();
        }

        @NotNull
        public final CompilerMessageSeverity component1() {
            return this.severity;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final CompilerMessageSourceLocation component3() {
            return this.location;
        }

        @NotNull
        public final Message copy(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new Message(severity, message2, location);
        }

        public static /* synthetic */ Message copy$default(Message message2, CompilerMessageSeverity compilerMessageSeverity, String string2, CompilerMessageSourceLocation compilerMessageSourceLocation, int n, Object object) {
            if ((n & 1) != 0) {
                compilerMessageSeverity = message2.severity;
            }
            if ((n & 2) != 0) {
                string2 = message2.message;
            }
            if ((n & 4) != 0) {
                compilerMessageSourceLocation = message2.location;
            }
            return message2.copy(compilerMessageSeverity, string2, compilerMessageSourceLocation);
        }

        public int hashCode() {
            int result2 = this.severity.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            result2 = result2 * 31 + (this.location == null ? 0 : this.location.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Message)) {
                return false;
            }
            Message message2 = (Message)other;
            if (this.severity != message2.severity) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)message2.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.location, (Object)message2.location);
        }
    }
}

