/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.diagnostics.StandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.backend.js.JsGenerationGranularity;
import org.jetbrains.kotlin.backend.js.TsCompilationStrategy;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.fir.FirDiagnosticsCompilerResultsReporter;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsStandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.WasmStandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.SourceMapNamesPolicy;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!2\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u0012\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160!*\u00020\u0016H\u0002\u001a\u0018\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\tH\u0000\u001a\u001e\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0000\u001a&\u0010+\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0!2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0000\u001a \u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u0002022\u0006\u0010%\u001a\u00020&H\u0000\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\" \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\" \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001b0\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019\" \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001e0\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019\u00a8\u00063"}, d2={"checkKotlinPackageUsageForPsi", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetVersion", "Lorg/jetbrains/kotlin/js/config/EcmaVersion;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "getTargetVersion", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;)Lorg/jetbrains/kotlin/js/config/EcmaVersion;", "granularity", "Lorg/jetbrains/kotlin/backend/js/JsGenerationGranularity;", "getGranularity", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;)Lorg/jetbrains/kotlin/backend/js/JsGenerationGranularity;", "dtsStrategy", "Lorg/jetbrains/kotlin/backend/js/TsCompilationStrategy;", "getDtsStrategy", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;)Lorg/jetbrains/kotlin/backend/js/TsCompilationStrategy;", "sourceMapContentEmbeddingMap", "", "", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "getSourceMapContentEmbeddingMap", "()Ljava/util/Map;", "sourceMapNamesPolicyMap", "Lorg/jetbrains/kotlin/js/config/SourceMapNamesPolicy;", "getSourceMapNamesPolicyMap", "moduleKindMap", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "getModuleKindMap", "configureLibraries", "", "libraryString", "splitByPathSeparator", "calculateSourceMapSourceRoot", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "arguments", "reportCompiledSourcesList", "", "sourceFiles", "runStandardLibrarySpecialCompatibilityChecks", "libraries", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "isWasm", "reportCollectedDiagnostics", "compilerConfiguration", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "cli-js"})
@SourceDebugExtension(value={"SMAP\nHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helpers.kt\norg/jetbrains/kotlin/cli/js/HelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,180:1\n295#2,2:181\n739#2,9:183\n1563#2:199\n1634#2,3:200\n37#3:192\n36#3,3:193\n4154#4:196\n4254#4,2:197\n*S KotlinDebug\n*F\n+ 1 Helpers.kt\norg/jetbrains/kotlin/cli/js/HelpersKt\n*L\n44#1:181,2\n98#1:183,9\n152#1:199\n152#1:200,3\n99#1:192\n99#1:193,3\n100#1:196\n100#1:197,2\n*E\n"})
public final class HelpersKt {
    @NotNull
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    @NotNull
    private static final Map<String, SourceMapNamesPolicy> sourceMapNamesPolicyMap;
    @NotNull
    private static final Map<String, ModuleKind> moduleKindMap;

    public static final boolean checkKotlinPackageUsageForPsi(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        return UtilsKt.checkKotlinPackageUsageForPsi$default(configuration2, files2, null, 4, null);
    }

    @Nullable
    public static final EcmaVersion getTargetVersion(@NotNull K2JSCompilerArguments $this$targetVersion) {
        EcmaVersion ecmaVersion;
        Intrinsics.checkNotNullParameter((Object)$this$targetVersion, (String)"<this>");
        String targetString = $this$targetVersion.getTarget();
        if (targetString != null) {
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$0;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EcmaVersion it = (EcmaVersion)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)targetString)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            ecmaVersion = v0;
        } else {
            ecmaVersion = EcmaVersion.defaultVersion();
        }
        return ecmaVersion;
    }

    @NotNull
    public static final JsGenerationGranularity getGranularity(@NotNull K2JSCompilerArguments $this$granularity) {
        Intrinsics.checkNotNullParameter((Object)$this$granularity, (String)"<this>");
        return $this$granularity.getIrPerFile() ? JsGenerationGranularity.PER_FILE : ($this$granularity.getIrPerModule() ? JsGenerationGranularity.PER_MODULE : JsGenerationGranularity.WHOLE_PROGRAM);
    }

    @NotNull
    public static final TsCompilationStrategy getDtsStrategy(@NotNull K2JSCompilerArguments $this$dtsStrategy) {
        Intrinsics.checkNotNullParameter((Object)$this$dtsStrategy, (String)"<this>");
        return !$this$dtsStrategy.getGenerateDts() ? TsCompilationStrategy.NONE : ($this$dtsStrategy.getIrPerFile() ? TsCompilationStrategy.EACH_FILE : TsCompilationStrategy.MERGED);
    }

    @NotNull
    public static final Map<String, SourceMapSourceEmbedding> getSourceMapContentEmbeddingMap() {
        return sourceMapContentEmbeddingMap;
    }

    @NotNull
    public static final Map<String, SourceMapNamesPolicy> getSourceMapNamesPolicyMap() {
        return sourceMapNamesPolicyMap;
    }

    @NotNull
    public static final Map<String, ModuleKind> getModuleKindMap() {
        return moduleKindMap;
    }

    @NotNull
    public static final List<String> configureLibraries(@Nullable String libraryString) {
        Object object = libraryString;
        if (object == null || (object = HelpersKt.splitByPathSeparator((String)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
        void $this$filterNotTo$iv$iv;
        List list;
        CharSequence charSequence = $this$splitByPathSeparator;
        String string2 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
        String string3 = string2;
        string3 = new Regex(string3);
        int n = 0;
        List $this$dropLastWhile$iv = string3.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        String[] $this$toTypedArray$iv = (String[])list;
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] $this$filterNot$iv = thisCollection$iv.toArray(new String[0]);
        boolean $i$f$filterNot = false;
        thisCollection$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (void element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String calculateSourceMapSourceRoot(@NotNull MessageCollector messageCollector, @NotNull K2JSCompilerArguments arguments) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        File commonPath = null;
        List pathToRoot = new ArrayList();
        HashMap pathToRootIndexes = new HashMap();
        try {
            for (String path : arguments.getFreeArgs()) {
                File file2;
                if (commonPath == null) {
                    commonPath = file2;
                    for (file2 = new File(path).getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                        pathToRoot.add(file2);
                    }
                    CollectionsKt.reverse((List)pathToRoot);
                    int n = ((Collection)pathToRoot).size();
                    for (int i = 0; i < n; ++i) {
                        Integer n2 = i;
                        ((Map)pathToRootIndexes).put(pathToRoot.get(i), n2);
                    }
                    continue;
                }
                while (file2 != null) {
                    Integer existingIndex = (Integer)pathToRootIndexes.get(file2);
                    if (existingIndex != null) {
                        existingIndex = Math.min(existingIndex, pathToRoot.size() - 1);
                        pathToRoot.subList(existingIndex + 1, pathToRoot.size()).clear();
                        commonPath = (File)pathToRoot.get(pathToRoot.size() - 1);
                        break;
                    }
                    file2 = file2.getParentFile();
                }
                if (file2 != null) continue;
                break;
            }
        }
        catch (IOException e) {
            String string2 = ExceptionUtil.getThrowableText(e);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getThrowableText(...)");
            String text = string2;
            messageCollector.report(CompilerMessageSeverity.ERROR, "IO error occurred calculating source root:\n" + text, null);
            return ".";
        }
        if ((object = commonPath) == null || (object = ((File)object).getPath()) == null) {
            object = ".";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final void reportCompiledSourcesList(@NotNull MessageCollector messageCollector, @NotNull List<? extends KtFile> sourceFiles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        Iterable $this$map$iv = sourceFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file2;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = file2.getVirtualFile();
            collection.add(virtualFile != null ? MessageUtil.virtualFileToPath(virtualFile) : file2.getName() + " (no virtual file)");
        }
        List fileNames = (List)destination$iv$iv;
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
    }

    public static final void runStandardLibrarySpecialCompatibilityChecks(@NotNull List<? extends KotlinLibrary> libraries, boolean isWasm, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        StandardLibrarySpecialCompatibilityChecker checker = isWasm ? (StandardLibrarySpecialCompatibilityChecker)WasmStandardLibrarySpecialCompatibilityChecker.INSTANCE : (StandardLibrarySpecialCompatibilityChecker)JsStandardLibrarySpecialCompatibilityChecker.INSTANCE;
        checker.check((Collection<? extends KotlinLibrary>)libraries, messageCollector);
    }

    public static final void reportCollectedDiagnostics(@NotNull CompilerConfiguration compilerConfiguration, @NotNull BaseDiagnosticsCollector diagnosticsReporter, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        boolean renderName = compilerConfiguration.getBoolean(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME);
        FirDiagnosticsCompilerResultsReporter.INSTANCE.reportToMessageCollector(diagnosticsReporter, messageCollector, renderName);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"always", (Object)((Object)SourceMapSourceEmbedding.ALWAYS)), TuplesKt.to((Object)"never", (Object)((Object)SourceMapSourceEmbedding.NEVER)), TuplesKt.to((Object)"inlining", (Object)((Object)SourceMapSourceEmbedding.INLINING))};
        sourceMapContentEmbeddingMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"no", (Object)((Object)SourceMapNamesPolicy.NO)), TuplesKt.to((Object)"simple-names", (Object)((Object)SourceMapNamesPolicy.SIMPLE_NAMES)), TuplesKt.to((Object)"fully-qualified-names", (Object)((Object)SourceMapNamesPolicy.FULLY_QUALIFIED_NAMES))};
        sourceMapNamesPolicyMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"plain", (Object)((Object)ModuleKind.PLAIN)), TuplesKt.to((Object)"commonjs", (Object)((Object)ModuleKind.COMMON_JS)), TuplesKt.to((Object)"amd", (Object)((Object)ModuleKind.AMD)), TuplesKt.to((Object)"umd", (Object)((Object)ModuleKind.UMD)), TuplesKt.to((Object)"es", (Object)((Object)ModuleKind.ES))};
        moduleKindMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EcmaVersion> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])EcmaVersion.values());
        }
    }
}

