/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLICompilerKt;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.pipeline.ArgumentsPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PipelineArtifactWithExitCode;
import org.jetbrains.kotlin.cli.pipeline.PipelineContext;
import org.jetbrains.kotlin.cli.pipeline.PipelineStepException;
import org.jetbrains.kotlin.cli.pipeline.SuccessfulPipelineExecutionException;
import org.jetbrains.kotlin.config.LoggingContext;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.config.phaser.CompilerPhase;
import org.jetbrains.kotlin.config.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J+\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0019\u001a\u00020\u00162\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001dR\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/AbstractCliPipeline;", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "", "<init>", "()V", "execute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "originalMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "runPhasedPipeline", "input", "Lorg/jetbrains/kotlin/cli/pipeline/ArgumentsPipelineArtifact;", "createCompoundPhase", "Lorg/jetbrains/kotlin/config/phaser/CompilerPhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelineContext;", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Lorg/jetbrains/kotlin/config/phaser/CompilerPhase;", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createPerformanceManager", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/config/Services;)Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "isKaptMode", "", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Z", "cli"})
public abstract class AbstractCliPipeline<A extends CommonCompilerArguments> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExitCode execute(@NotNull A arguments, @NotNull Services services, @NotNull MessageCollector originalMessageCollector) {
        ExitCode exitCode;
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)originalMessageCollector, (String)"originalMessageCollector");
        CompilationCanceledStatus canceledStatus = services.get(CompilationCanceledStatus.class);
        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(canceledStatus);
        Disposable disposable = Disposer.newDisposable("Disposable for " + Reflection.getOrCreateKotlinClass(CLICompiler.class).getSimpleName() + ".execImpl");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable rootDisposable = disposable;
        UtilKt.setIdeaIoUseFallback();
        CommonCompilerPerformanceManager performanceManager2 = this.createPerformanceManager(arguments, services);
        if (((CommonCompilerArguments)arguments).getReportPerf() || ((CommonCompilerArguments)arguments).getDumpPerf() != null) {
            performanceManager2.enableCollectingPerformanceStatistics();
        }
        GroupingMessageCollector messageCollector = new GroupingMessageCollector(originalMessageCollector, ((CommonToolArguments)arguments).getAllWarningsAsErrors(), ((CommonCompilerArguments)arguments).getReportAllWarnings());
        ArgumentsPipelineArtifact<A> argumentsInput = new ArgumentsPipelineArtifact<A>(arguments, services, rootDisposable, messageCollector, performanceManager2);
        try {
            ExitCode code = this.runPhasedPipeline(argumentsInput);
            performanceManager2.notifyCompilationFinished();
            if (((CommonCompilerArguments)arguments).getReportPerf()) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "PERF: " + performanceManager2.getTargetInfo(), null, 4, null);
                for (PerformanceMeasurement measurement : performanceManager2.getMeasurementResults()) {
                    messageCollector.report(CompilerMessageSeverity.LOGGING, "PERF: " + measurement.render(), null);
                }
            }
            if (((CommonCompilerArguments)arguments).getDumpPerf() != null) {
                String string2 = ((CommonCompilerArguments)arguments).getDumpPerf();
                Intrinsics.checkNotNull((Object)string2);
                performanceManager2.dumpPerformanceReport(new File(string2));
            }
            exitCode = messageCollector.hasErrors() ? ExitCode.COMPILATION_ERROR : code;
        }
        catch (CompilationErrorException compilationErrorException) {
            exitCode = ExitCode.COMPILATION_ERROR;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            exitCode = cause instanceof CompilationCanceledException ? AbstractCliPipeline.execute$reportCompilationCanceled(messageCollector, (CompilationCanceledException)cause) : AbstractCliPipeline.execute$reportException(messageCollector, e);
        }
        catch (Throwable t) {
            exitCode = AbstractCliPipeline.execute$reportException(messageCollector, t);
        }
        finally {
            messageCollector.flush();
            Disposer.dispose(rootDisposable);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExitCode runPhasedPipeline(ArgumentsPipelineArtifact<? extends A> input) {
        ExitCode exitCode;
        CompilerPhase<PipelineContext, ArgumentsPipelineArtifact<A>, ?> compoundPhase = this.createCompoundPhase(input.getArguments());
        PhaseConfig phaseConfig = new PhaseConfig(null, null, null, null, null, null, null, null, false, false, false, 2047, null);
        PipelineContext context = new PipelineContext(input.getMessageCollector(), input.getDiagnosticCollector(), input.getPerformanceManager(), ((CommonCompilerArguments)input.getArguments()).getRenderInternalDiagnosticNames(), this.isKaptMode(input.getArguments()));
        try {
            Object result2 = CompilerPhaseKt.invokeToplevel(compoundPhase, phaseConfig, (LoggingContext)context, input);
            exitCode = result2 instanceof PipelineArtifactWithExitCode ? ((PipelineArtifactWithExitCode)result2).getExitCode() : ExitCode.OK;
        }
        catch (PipelineStepException e) {
            exitCode = e.getDefinitelyCompilationError() || input.getMessageCollector().hasErrors() || input.getDiagnosticCollector().getHasErrors() ? ExitCode.COMPILATION_ERROR : ExitCode.OK;
        }
        catch (SuccessfulPipelineExecutionException successfulPipelineExecutionException) {
            exitCode = ExitCode.OK;
        }
        finally {
            CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE.reportDiagnosticsToMessageCollector(context);
        }
        return exitCode;
    }

    @NotNull
    public abstract CompilerPhase<PipelineContext, ArgumentsPipelineArtifact<A>, ?> createCompoundPhase(@NotNull A var1);

    @NotNull
    public abstract CommonCompilerPerformanceManager getDefaultPerformanceManager();

    @NotNull
    protected CommonCompilerPerformanceManager createPerformanceManager(@NotNull A arguments, @NotNull Services services) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        return this.getDefaultPerformanceManager();
    }

    protected boolean isKaptMode(@NotNull A arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return false;
    }

    private static final ExitCode execute$reportException(GroupingMessageCollector messageCollector, Throwable e) {
        MessageCollectorUtil.reportException(messageCollector, e);
        return e instanceof OutOfMemoryError || CLICompilerKt.hasOOMCause(e) ? ExitCode.OOM_ERROR : ExitCode.INTERNAL_ERROR;
    }

    private static final ExitCode execute$reportCompilationCanceled(GroupingMessageCollector messageCollector, CompilationCanceledException e) {
        CLICompilerKt.reportCompilationCancelled(messageCollector, e);
        return ExitCode.OK;
    }
}

