/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorage;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.DynamicComponentDescriptor;
import org.jetbrains.kotlin.container.IterableDescriptor;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\"2\b\b\u0002\u0010\u001e\u001a\u00020\u0012J\u001b\u0010#\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0000\u00a2\u0006\u0002\b'J\u001f\u0010(\u001a\u00020\u00002\u0010\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0%H\u0000\u00a2\u0006\u0002\b+J!\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H-0\"H\u0016\u00a2\u0006\u0002\u0010.J\b\u00102\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "Ljava/io/Closeable;", "id", "", "parent", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/container/StorageComponentContainer;)V", "unknownContext", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "getUnknownContext", "()Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "unknownContext$delegate", "Lkotlin/Lazy;", "componentStorage", "Lorg/jetbrains/kotlin/container/ComponentStorage;", "createResolveContext", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "requestingDescriptor", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "compose", "dump", "", "printer", "Ljava/io/PrintStream;", "close", "resolve", "request", "Ljava/lang/reflect/Type;", "context", "resolveIterable", "resolveMultiple", "", "Ljava/lang/Class;", "registerDescriptors", "descriptors", "", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "registerDescriptors$container", "registerClashResolvers", "resolvers", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "registerClashResolvers$container", "create", "T", "(Ljava/lang/Class;)Ljava/lang/Object;", "containerId", "getContainerId", "()Ljava/lang/String;", "toString", "container"})
@SourceDebugExtension(value={"SMAP\nContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Container.kt\norg/jetbrains/kotlin/container/StorageComponentContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 reflectHelpers.kt\norg/jetbrains/kotlin/container/ReflectHelpersKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1563#2:143\n1634#2,3:144\n37#3:147\n36#3,3:148\n11#4,5:151\n1#5:156\n*S KotlinDebug\n*F\n+ 1 Container.kt\norg/jetbrains/kotlin/container/StorageComponentContainer\n*L\n114#1:143\n114#1:144,3\n114#1:147\n114#1:148,3\n115#1:151,5\n*E\n"})
public final class StorageComponentContainer
implements Closeable,
ComponentContainer,
ComponentProvider {
    @NotNull
    private final String id;
    @NotNull
    private final Lazy unknownContext$delegate;
    @NotNull
    private final ComponentStorage componentStorage;

    public StorageComponentContainer(@NotNull String id, @Nullable StorageComponentContainer parent2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.unknownContext$delegate = LazyKt.lazy(() -> StorageComponentContainer.unknownContext_delegate$lambda$1(parent2, this));
        StorageComponentContainer storageComponentContainer = parent2;
        this.componentStorage = new ComponentStorage(this.id, storageComponentContainer != null ? storageComponentContainer.componentStorage : null);
    }

    public /* synthetic */ StorageComponentContainer(String string2, StorageComponentContainer storageComponentContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            storageComponentContainer = null;
        }
        this(string2, storageComponentContainer);
    }

    @NotNull
    public final ComponentResolveContext getUnknownContext() {
        Lazy lazy = this.unknownContext$delegate;
        return (ComponentResolveContext)lazy.getValue();
    }

    @Override
    @NotNull
    public ValueResolveContext createResolveContext(@NotNull ValueDescriptor requestingDescriptor) {
        Intrinsics.checkNotNullParameter((Object)requestingDescriptor, (String)"requestingDescriptor");
        if (Intrinsics.areEqual((Object)requestingDescriptor, (Object)DynamicComponentDescriptor.INSTANCE)) {
            return this.getUnknownContext();
        }
        return new ComponentResolveContext(this, requestingDescriptor, null, 4, null);
    }

    @NotNull
    public final StorageComponentContainer compose() {
        this.componentStorage.compose(this.getUnknownContext());
        return this;
    }

    public final void dump(@NotNull PrintStream printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.componentStorage.dump(printer);
    }

    @Override
    public void close() {
        this.componentStorage.dispose();
    }

    @Nullable
    public final ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ValueDescriptor valueDescriptor = this.componentStorage.resolve(request, context);
        if (valueDescriptor == null) {
            valueDescriptor = this.resolveIterable(request, context);
        }
        return valueDescriptor;
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.resolve(request, this.getUnknownContext());
    }

    private final ValueDescriptor resolveIterable(Type request, ValueResolveContext context) {
        Type type2;
        if (!(request instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)request).getRawType();
        if (!Intrinsics.areEqual((Object)rawType, Iterable.class)) {
            return null;
        }
        Type[] typeArguments = ((ParameterizedType)request).getActualTypeArguments();
        if (typeArguments.length != 1) {
            return null;
        }
        Type iterableTypeArgument = typeArguments[0];
        Type type3 = iterableTypeArgument;
        if (type3 instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)iterableTypeArgument).getUpperBounds();
            if (upperBounds.length != 1) {
                return null;
            }
            type2 = upperBounds[0];
        } else if (type3 instanceof Class) {
            type2 = iterableTypeArgument;
        } else if (type3 instanceof ParameterizedType) {
            type2 = iterableTypeArgument;
        } else {
            return null;
        }
        Type iterableType = type2;
        Intrinsics.checkNotNull((Object)iterableType);
        return new IterableDescriptor(this.componentStorage.resolveMultiple(iterableType, context));
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Class<?> request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.componentStorage.resolveMultiple(request, context);
    }

    public static /* synthetic */ Iterable resolveMultiple$default(StorageComponentContainer storageComponentContainer, Class clazz, ValueResolveContext valueResolveContext, int n, Object object) {
        if ((n & 2) != 0) {
            valueResolveContext = storageComponentContainer.getUnknownContext();
        }
        return storageComponentContainer.resolveMultiple(clazz, valueResolveContext);
    }

    @NotNull
    public final StorageComponentContainer registerDescriptors$container(@NotNull List<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        this.componentStorage.registerDescriptors$container(this.getUnknownContext(), descriptors);
        return this;
    }

    @NotNull
    public final StorageComponentContainer registerClashResolvers$container(@NotNull List<? extends PlatformExtensionsClashResolver<?>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        this.componentStorage.registerClashResolvers$container(resolvers);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T create(@NotNull Class<T> request) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        ConstructorBinding constructorBinding = ResolveKt.bindToConstructor(request, this.getContainerId(), this.getUnknownContext());
        Iterable $this$map$iv = constructorBinding.getArgumentDescriptors();
        boolean $i$f$map = false;
        Iterable<Object> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] args = thisCollection$iv.toArray(new Object[0]);
        boolean $i$f$runWithUnwrappingInvocationException = false;
        try {
            boolean bl = false;
            iterable = constructorBinding.getConstructor().newInstance(Arrays.copyOf(args, args.length));
        }
        catch (InvocationTargetException e$iv) {
            Throwable throwable = e$iv.getTargetException();
            if (throwable == null) {
                throwable = e$iv;
            }
            throw throwable;
        }
        return (T)iterable;
    }

    @Override
    @NotNull
    public String getContainerId() {
        return "Container: " + this.id;
    }

    @NotNull
    public String toString() {
        return this.getContainerId();
    }

    private static final ComponentResolveContext unknownContext_delegate$lambda$1(StorageComponentContainer $parent, StorageComponentContainer this$0) {
        ComponentResolveContext componentResolveContext;
        StorageComponentContainer storageComponentContainer = $parent;
        if (storageComponentContainer != null) {
            StorageComponentContainer it = storageComponentContainer;
            boolean bl = false;
            componentResolveContext = new ComponentResolveContext(it, DynamicComponentDescriptor.INSTANCE, null, 4, null);
        } else {
            componentResolveContext = null;
        }
        ComponentResolveContext parentContext = componentResolveContext;
        return new ComponentResolveContext(this$0, DynamicComponentDescriptor.INSTANCE, parentContext);
    }
}

